% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_parameters.R
\name{select_smoothing}
\alias{select_smoothing}
\title{Optimal Smoothing Parameter for ssMRCD based on Residuals}
\usage{
select_smoothing(
  X,
  groups,
  weights,
  lambda = seq(0, 1, 0.1),
  TM = NULL,
  alpha = 0.75,
  seed = 123436,
  return_all = TRUE,
  cores = 1
)
}
\arguments{
\item{X}{data matrix containing observations.}

\item{groups}{grouping vector corresponding to \code{X}.}

\item{weights}{weight matrix for groups, see \code{\link[ssMRCD]{rescale_weights}}, and \code{\link[ssMRCD]{geo_weights}}.}

\item{lambda}{vector of parameter values for smoothing, between 0 and 1.}

\item{TM}{target matrix, if not given MCD (or MRCD if non regular) is used with default values and \code{alpha}.}

\item{alpha}{percentage of outliers to be expected.}

\item{seed}{seed for ssMRCD calculations.}

\item{return_all}{logical, if FALSE the function returns only the optimal lambda.}

\item{cores}{integer, number of cores used for parallel computing.}
}
\value{
\tabular{ll}{
   \code{lambda_opt} \tab optimal lambda for smoothing. \cr
   \tab \cr
   \code{COVS} \tab \code{ssMRCD} object with optimal parameter setting. \cr
   \tab \cr
   \code{plot} \tab plot for optimal parameter setting. \cr
   \tab \cr
   \code{residuals} \tab mean of norm of residuals for varying lambda. \cr
}
}
\description{
The optimal smoothing value for the ssMRCD estimator is based on the residuals and the
trimmed mean of the norm.
}
\examples{
# create data set
x1 = matrix(runif(200), ncol = 2)
x2 = matrix(rnorm(200), ncol = 2)

# create weighting matrix
W = matrix(c(0, 1, 1, 0), ncol = 2)

select_smoothing (X = rbind(x1, x2),
                 groups = rep(c(1,2), each = 100),
                 weights = W,
                 lambda = seq(0, 1, 0.1),
                 return_all = TRUE,
                 cores = 1)
}
