% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/locOuts.R
\name{locOuts}
\alias{locOuts}
\title{Local Outlier Detection using Spatially Smoothed MRCD}
\usage{
locOuts(data, coords, groups, lambda, weights = NULL, k = NULL, dist = NULL)
}
\arguments{
\item{data}{A numeric matrix of observations (rows = observations, columns = variables).}

\item{coords}{A numeric matrix of spatial coordinates corresponding to the observations.}

\item{groups}{A vector assigning each observation to a neighborhood/group.}

\item{lambda}{Smoothing parameter for the \code{\link[ssMRCD]{ssMRCD}} estimator.}

\item{weights}{Optional weighting matrix for spatial smoothing. If omitted, inverse-distance weights are computed automatically.}

\item{k}{Integer. Number of nearest neighbors to use if \code{dist} is not provided.}

\item{dist}{Numeric. Use neighbors within this distance instead of \code{k}-nearest neighbors. If both are provided, \code{dist} is used.}
}
\value{
An object of class \code{"locOuts"} containing:
\describe{
  \item{\code{outliers}}{Indices of detected outliers.}
  \item{\code{next_distance}}{Vector of Mahalanobis next distances (min distance to neighbors).}
  \item{\code{cutoff}}{Upper fence of the adjusted boxplot used as outlier threshold.}
  \item{\code{coords}}{Matrix of observation coordinates.}
  \item{\code{data}}{Original data matrix.}
  \item{\code{groups}}{Group assignments.}
  \item{\code{k, dist}}{Neighborhood comparison parameters used.}
  \item{\code{centersN}}{Centers of neighborhoods.}
  \item{\code{matneighbor}}{Binary matrix indicating which neighbors were used for each observation.}
  \item{\code{ssMRCD}}{The fitted \code{ssMRCD} object.}
}
}
\description{
Identifies local multivariate outliers using spatially smoothed robust covariance estimation (ssMRCD) as proposed by Puchhammer and Filzmoser (2023). For each observation, the Mahalanobis distance to its nearest neighbor is computed, and an adjusted boxplot is used to detect outliers.
}
\examples{
data <- matrix(rnorm(2000), ncol = 4)
coords <- matrix(runif(1000), ncol = 2)
groups <- sample(1:10, 500, replace = TRUE)
result <- locOuts(data, coords, groups, lambda = 0.3, k = 10)
}
\references{
Puchhammer, P. and Filzmoser, P. (2023). Spatially Smoothed Robust Covariance Estimation for Local Outlier Detection. *Journal of Computational and Graphical Statistics*, 33(3), 928–940. \doi{10.1080/10618600.2023.2277875}
}
\seealso{
\code{\link[ssMRCD]{ssMRCD}}, \code{\link[ssMRCD]{plot.locOuts}}
}
