% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/createVarCov.R
\name{report.varCov}
\alias{report.varCov}
\title{Report method for class varCov}
\usage{
\method{report}{varCov}(x, ..., outfile = NULL)
}
\arguments{
\item{x}{An object of class varCov.}

\item{...}{Not used.}

\item{outfile}{A character string, the name and location of the output .pdf
and .tex file for the report. If \code{NULL}, a report with a default name
will be created in the current working directory.}
}
\value{
A pdf and tex report.
}
\description{
A pdf report will be created containing a summary of an object of class
varCov. Simultaneously the same report will be created as a tex
file.
}
\examples{
\donttest{
## Select the best variance-covariance model using asreml for modeling.
if (requireNamespace("asreml", quietly = TRUE)) {
  geVarCov <- gxeVarCov(TD = TDMaize, trait = "yld", engine = "asreml")

  ## Create a pdf report summarizing the results.
  report(geVarCov, outfile = tempfile(fileext = ".pdf"))
  }
}

}
\seealso{
Other varCov: 
\code{\link{fitted.varCov}()},
\code{\link{gxeVarCov}()},
\code{\link{plot.varCov}()},
\code{\link{residuals.varCov}()}
}
\concept{varCov}
