% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy-model-expressions.R
\name{tidy_model_expressions}
\alias{tidy_model_expressions}
\title{Expressions with statistics for tidy regression data frames}
\usage{
tidy_model_expressions(
  data,
  statistic = NULL,
  digits = 2L,
  effsize.type = "omega",
  ...
)
}
\arguments{
\item{data}{A tidy data frame from regression model object (see
\code{\link[=tidy_model_parameters]{tidy_model_parameters()}}).}

\item{statistic}{Which statistic is to be displayed (either \code{"t"} or \code{"f"}or
\code{"z"} or \code{"chi"}) in the expression.}

\item{digits}{Number of digits for rounding or significant figures. May also
be \code{"signif"} to return significant figures or \code{"scientific"}
to return scientific notation. Control the number of digits by adding the
value as suffix, e.g. \code{digits = "scientific4"} to have scientific
notation with 4 decimal places, or \code{digits = "signif5"} for 5
significant figures (see also \code{\link[=signif]{signif()}}).}

\item{effsize.type}{Type of effect size needed for \emph{parametric} tests. The
argument can be \code{"eta"} (partial eta-squared) or \code{"omega"} (partial
omega-squared).}

\item{...}{Currently ignored.}
}
\description{
Expressions with statistics for tidy regression data frames
}
\details{
When any of the necessary numeric column values (\code{estimate}, \code{statistic},
\code{p.value}) are missing, for these rows, a \code{NULL} is returned instead of an
expression with empty strings.
}
\section{Citation}{
Patil, I., (2021). statsExpressions: R Package for Tidy Dataframes and Expressions with Statistical Details. Journal of Open Source Software, 6(61), 3236, https://doi.org/10.21105/joss.03236
}

\examples{
\dontshow{if (identical(Sys.getenv("NOT_CRAN"), "true")) withAutoprint(\{ # examplesIf}
# setup
set.seed(123)
library(statsExpressions)

# extract a tidy data frame
df <- tidy_model_parameters(lm(wt ~ am * cyl, mtcars))

# create a column containing expression; the expression will depend on `statistic`
tidy_model_expressions(df, statistic = "t")
tidy_model_expressions(df, statistic = "z")
tidy_model_expressions(df, statistic = "chi")
\dontshow{\}) # examplesIf}
}
