% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/forest.R
\name{createForestSamples}
\alias{createForestSamples}
\title{Create a container of forest samples}
\usage{
createForestSamples(
  num_trees,
  leaf_dimension = 1,
  is_leaf_constant = FALSE,
  is_exponentiated = FALSE
)
}
\arguments{
\item{num_trees}{Number of trees}

\item{leaf_dimension}{Dimensionality of the outcome model}

\item{is_leaf_constant}{Whether leaf is constant}

\item{is_exponentiated}{Whether forest predictions should be exponentiated before being returned}
}
\value{
\code{ForestSamples} object
}
\description{
Create a container of forest samples
}
\examples{
num_trees <- 100
leaf_dimension <- 2
is_leaf_constant <- FALSE
is_exponentiated <- FALSE
forest_samples <- createForestSamples(num_trees, leaf_dimension, is_leaf_constant, is_exponentiated)
}
