% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{createPreprocessorFromJson}
\alias{createPreprocessorFromJson}
\title{Reload a covariate preprocessor object from a JSON string containing a serialized preprocessor}
\usage{
createPreprocessorFromJson(json_object)
}
\arguments{
\item{json_object}{in-memory wrapper around JSON C++ object containing covariate preprocessor metadata}
}
\value{
Preprocessor object that can be used with the \code{preprocessPredictionData} function
}
\description{
Reload a covariate preprocessor object from a JSON string containing a serialized preprocessor
}
\examples{
cov_mat <- matrix(1:12, ncol = 3)
preprocess_list <- preprocessTrainData(cov_mat)
preprocessor_json <- convertPreprocessorToJson(preprocess_list$metadata)
preprocessor_roundtrip <- createPreprocessorFromJson(preprocessor_json)
}
