% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_sulci.R
\name{plot_sulci}
\alias{plot_sulci}
\title{Plot sulcal measures on brain}
\usage{
plot_sulci(
  sulcus_values,
  palette = "gyr",
  value_range = NULL,
  save_dir = NULL,
  measure = c("all", "opening", "depth", "surface", "length"),
  show_colorbar = TRUE,
  caption = expression(-log[10](p)),
  ...
)
}
\arguments{
\item{sulcus_values}{data.frame or path/to/csv
Either (1) a two-column dataframe with \code{Sulcus} and \code{Value}, or
(2) a path to a CSV file containing those columns.
\code{Sulcus} must use BrainVISA-style tags (left/right, 4 types) and include all
expected names. Missing sulcus should have \code{Value = 0} (see README and data samples).}

\item{palette}{character
Color palette for mapping values and the colorbar. Options include
\code{"viridis"}, \code{"magma"}, \code{"plasma"}, \code{"inferno"}, \code{"cividis"}, \code{"heat"}, \code{"gyr"}.}

\item{value_range}{numeric length-2 or NULL (default \code{NULL})
Controls the color scale.
\itemize{
\item \code{NULL}: auto-scale from the min/max of the provided values.
\item \code{c(min, max)}: fix the scale across plots/conditions for comparability.
}}

\item{save_dir}{character or NULL (default \code{NULL})
Directory where the plot image(s) are saved. If it does not exist, it will
be created. Set to \code{NULL} to skip saving and only return the plot object.}

\item{measure}{character
What to plot:
\itemize{
\item \code{"all"}: generate all four measures in one figure.
\item \code{"opening"}, \code{"depth"}, \code{"surface"}, \code{"length"}: generate a single-measure plot.
}}

\item{show_colorbar}{logical Show or hide the color bar on the figure.}

\item{caption}{character or expression
Label displayed with the color bar. For math, use e.g. \code{expression(-log[10](p))}.}

\item{...}{Advanced options:
\code{base_dir} (path to assets),
\code{scale_width} (magick scale, default "1000x"),
\code{file_prefix} (default "sulci"),
\code{width_in}, \code{height_in} (inches; defaults 14, 8),
\code{dpi} (default 300).}
}
\value{
If \code{save_dir = NULL}, returns a \code{ggplot} (or \code{patchwork}) object
representing the brain figure, which can be further modified and saved.
If \code{save_dir} is not \code{NULL}, the plot image(s) are automatically saved in that directory
and the function (invisibly) returns a character vector with the path(s) to the saved file(s).
}
\description{
Generates composite brain figures (left/right lateral/medial) by mapping sulcal values.
}
\examples{
# Minimal executable example using assets_light
ex <- data.frame(
  Sulcus = c("S.C._left.opening", "S.C._right.opening",
  "S.F.int._left.opening", "S.F.int._right.opening"),
  Value  = c(1, 0.5, 0.8, 0.4)
)
assets_light <- sulcimap::get_assets_light()
p <- plot_sulci(
  sulcus_values = ex,
  measure       = "opening",
  palette       = "gyr",
  show_colorbar = FALSE,
  base_dir      = assets_light,
  save_dir      = NULL
)
# p is a ggplot/patchwork object; printing it will draw the figure.

\donttest{
# Full example
# df should have columns: Sulcus (BrainVISA-style names with suffixes), Value
# plot_out <- plot_sulci(
#  sulcus_values = df,
#    palette       = "gyr",
#   value_range   = NULL,
#  save_dir      = NULL,
#    measure       = "opening",
#    show_colorbar = TRUE,
#    caption       = expression(-log[10](p))
# )
}
}
