% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vcov3_fixest.R
\name{vcov_CR3J.fixest}
\alias{vcov_CR3J.fixest}
\title{Compute CRV3 covariance matrices via a cluster
jackknife as described in MacKinnon, Nielsen & Webb
(2022) for objects of type \code{fixest}}
\usage{
\method{vcov_CR3J}{fixest}(
  obj,
  cluster,
  type = "CRV3",
  return_all = FALSE,
  absorb_cluster_fixef = TRUE,
  ...
)
}
\arguments{
\item{obj}{An object of type fixest}

\item{cluster}{A clustering vector}

\item{type}{"CRV3" or "CRV3J" following MacKinnon, Nielsen & Webb.
CRV3 by default}

\item{return_all}{Logical scalar, FALSE by default. Should only
the vcov be returned (FALSE) or additional results (TRUE)}

\item{absorb_cluster_fixef}{TRUE by default. Should the cluster fixed
effects be projected out? This increases numerical stability.}

\item{...}{other function arguments passed to 'vcov'}
}
\value{
An object of class \code{vcov_CR3J}
}
\description{
Compute CRV3 covariance matrices via a cluster
jackknife as described in MacKinnon, Nielsen & Webb
(2022) for objects of type \code{fixest}
}
\examples{

library(summclust)
library(fixest)
data(mtcars)
mtcars

fit <- feols(mpg ~ cyl + disp + hp, data = mtcars)
summ <- vcov_CR3J(fit, cluster = ~carb)

}
\references{
MacKinnon, James G., Morten Ørregaard Nielsen, and Matthew D. Webb.
"Leverage, influence, and the jackknife in clustered regression models:
Reliable inference using summclust."
arXiv preprint arXiv:2205.03288 (2022).
}
