% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tab_styles.R
\name{style_color}
\alias{style_color}
\title{style_color}
\usage{
style_color(primary_color = "#ffffff")
}
\arguments{
\item{primary_color}{color to be used for the title, header, and row names
background. This must be a hex code for the color.}
}
\value{
a list with styling options
}
\description{
Provides a simple way to define a color scheme for tables. By default, tables
have a "light" theme, where the background is white and text / lines are black.
Based on a primary color, style_color will create tables that use the primary
color as background for all title, header, and row name cells and adapts the
text color based on the primary color. The automatic adaption of the
background color is implemented based on Mark Ransom and SudoPlz at
<https://stackoverflow.com/questions/3942878/how-to-decide-font-color-in-white-or-black-depending-on-background-color>
}
\examples{
library(tablespan)
library(dplyr)
data("mtcars")

# First summarize the data:
summarized_table <- mtcars |>
  group_by(cyl, vs) |>
  summarise(N = n(),
            mean_hp = mean(hp),
            sd_hp = sd(hp),
            mean_wt = mean(wt),
            sd_wt = sd(wt))

# Now, we want to create a table, where we show the grouping variables
# as row names and also create spanners for the horse power (hp) and the
# weight (wt) variables:
tbl <- tablespan(data = summarized_table,
          formula = Cylinder:cyl + Engine:vs ~
            N +
            (`Horse Power` = Mean:mean_hp + SD:sd_hp) +
            (`Weight` = Mean:mean_wt + SD:sd_wt),
          title = "Motor Trend Car Road Tests",
          subtitle = "A table created with tablespan",
          footnote = "Data from the infamous mtcars data set.")

# We can save this table with the default color scheme:
wb <- as_excel(tbl = tbl)

# Or adapt the color scheme to our liking:
wb <- as_excel(tbl = tbl,
               styles = style_color(primary_color = "#2e9199"))

# Create the excel table:
# openxlsx::saveWorkbook(wb,
#                        file = "cars.xlsx",
#                        overwrite = TRUE)
}
