% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/test_intersection_sw.R
\name{test_intersection_sw}
\alias{test_intersection_sw}
\title{Signed Wald intersection test}
\usage{
test_intersection_sw(
  par,
  vcov,
  noninf = 0,
  weights = 1,
  nsim.null = 10000,
  index = NULL,
  control = list(),
  par.name = "theta"
)
}
\arguments{
\item{par}{(numeric) parameter estimates or \code{estimate} object}

\item{vcov}{(matrix) asymptotic variance estimate}

\item{noninf}{(numeric) non-inferiority margins}

\item{weights}{(numeric) optional weights}

\item{nsim.null}{(integer) number of sample used in Monte-Carlo simulation}

\item{index}{(integer) subset of parameters to test}

\item{control}{(list) arguments to alternating projection algorithm. See
details section.}

\item{par.name}{(character) parameter names in output}
}
\value{
\code{htest} object
}
\description{
Calculating test statistics and p-values for the signed Wald
intersection test given by \deqn{SW = \inf_{\theta \in \cap_{i=1}^n H_i}
  \{(\widehat{\theta}-\theta)^\top W\widehat{\Sigma}W
  (\widehat{\theta}-\theta)\} } with individual hypotheses for each
coordinate of \eqn{\theta} given by \eqn{H_i: \theta_j < \delta_j} for some
non-inferiority margin \eqn{\delta_j}, \eqn{j=1,\ldots,n}. #
}
\details{
The constrained least squares problem is solved using Dykstra's
algorithm. The following parameters for the optimization can be controlled
via the \code{control} list argument: \code{dykstra_niter} sets the maximum number of
iterations (default 500), \code{dykstra_tol} convergence tolerance of the
alternating projection algorithm (default 1e-7), \code{pinv_tol} tolerance for
calculating the pseudo-inverse matrix (default
length(par)\emph{.Machine$double.eps}max(eigenvalue)).
}
\examples{
S <- matrix(c(1, 0.5, 0.5, 2), 2, 2)
thetahat <- c(0.5, -0.2)
test_intersection_sw(thetahat, S, nsim.null = 1e5)
test_intersection_sw(thetahat, S, weights = NULL)

\dontrun{
# only on 'lava' >= 1.8.2
e <- estimate(coef = thetahat, vcov = S, labels = c("p1", "p2"))
lava::closed_testing(e, test_intersection_sw, noninf = c(-0.1, -0.1)) |>
  summary()
}
}
\references{
Christian Bressen Pipper, Andreas Nordland & Klaus Kähler Holst
(2025) A general approach to construct powerful tests for intersections of
one-sided null-hypotheses based on influence functions. arXiv:
https://arxiv.org/abs/2511.07096.
}
\seealso{
\link{test_zmax_onesided} \link[lava:compare]{lava::test_wald} \link[lava:closed_testing]{lava::closed_testing}
}
\author{
Klaus Kähler Holst, Christian Bressen Pipper
}
