% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pd_mods.R
\name{emax_inv_eleveld}
\alias{emax_inv_eleveld}
\title{Inverse Emax function}
\usage{
emax_inv_eleveld(pdresp, pars)
}
\arguments{
\item{pdresp}{PD response values}

\item{pars}{Named vector of parameter values with names (c50,gamma,E0,Emx).}
}
\value{
Numeric vector of same length as pdresp.
}
\description{
Inverse of Emax function used by Eleveld population PK model.
}
\examples{
pars_emax_eleveld <- c(c50 = 1.5, e0 = 100, gamma = 1.47, gamma2 = 1.89)
ce_seq <- seq(0,4,0.1)
all.equal(emax_inv_eleveld(emax_eleveld(ce_seq, pars_emax_eleveld), pars_emax_eleveld), ce_seq)
}
