% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pd_mods.R
\name{emax_remi}
\alias{emax_remi}
\title{Emax function implemented by Eleveld remifentanil model}
\usage{
emax_remi(ce, pars)
}
\arguments{
\item{ce}{Vector of effect-site concentrations.}

\item{pars}{Named vector of parameter values with names (c50,gamma,e0,emx).}
}
\value{
Numeric vector of same length as ce.
}
\description{
Emax function. c50 is the concentration eliciting a 50% effect, gamma is the hill parameter
identifying the slope of the Emax curve at c50, E0 is the response value with no drug present,
Emx is the maximum effect size.
}
\examples{
pars_emax <- c(e0 = 19, emx = 5.6, c50 = 12.7, gamma = 2.87)
ce_seq <- seq(0,60,0.1)
plot(ce_seq, emax_remi(ce_seq, pars_emax), type = "l",
xlab = "Effect-site concentrtion (ug/mL)", ylab = "Spectral Edge Frequency (HZ)")
}
