% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poppk_mods.R
\name{pkmod_eleveld_ppf}
\alias{pkmod_eleveld_ppf}
\title{Eleveld population PK model for propofol}
\usage{
pkmod_eleveld_ppf(
  AGE,
  TBW,
  HGT,
  MALE,
  OPIATE = TRUE,
  ARTERIAL = TRUE,
  PMA = NULL,
  PD = TRUE,
  ...
)
}
\arguments{
\item{AGE}{Age (years)}

\item{TBW}{Weight (kg)}

\item{HGT}{Height (cm)}

\item{MALE}{Sex, logical}

\item{OPIATE}{Logical indicating presence of opiates. Defaults to TRUE.}

\item{ARTERIAL}{PK based on arterial sampling rather than venous. Defaults to TRUE.}

\item{PMA}{Post-menstrual age. Calculated as AGE + 40 weeks if not provided.}

\item{PD}{Logical. Should PD parameters be returned in addition to PK parameters.}

\item{...}{Arguments passed to `pkmod`}
}
\value{
`pkmod` object with Eleveld propofol population PK or PK-PD parameters
}
\description{
Function takes patient covariate values required for the Eleveld
PK or PK-PD model for propofol and returns a `pkmod` object with the appropriate model
parameters.
}
\examples{
pkmod_eleveld_ppf(AGE = 40,TBW = 56,HGT=150,MALE = TRUE)
}
