% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/poppk_mods.R
\name{sample_iiv}
\alias{sample_iiv}
\title{Sample PK or PK-PD parameters from the distribution of inter- or intra-individual variability}
\usage{
sample_iiv(mod, log_normal = TRUE, ...)
}
\arguments{
\item{mod}{`pkmod` or `poppkmod` object with associated Omega matrix describing random effect variances}

\item{log_normal}{Logical. Assumes random effects are log-normally distributed
and multiplicative if TRUE, additive and normally distributed if FALSE.}

\item{...}{Arguments passed to update.pkmod.}
}
\value{
Returns model passed to "mod" argument with randomly sampled PK or PK-PD
parameters.
}
\description{
Sample PK or PK-PD parameters from the distribution of random effects
for a `pkmod` or `poppkmod` object, as described by the Omega matrix (see ?pkmod).
}
\examples{
# sample from single PK model
sample_iiv(pkmod_schnider(AGE = 40,HGT=170,TBW=50,MALE=TRUE))
# sample from `poppkmod`
data <- data.frame(ID = 1:5, AGE = seq(20,60,by=10), TBW = seq(60,80,by=5),
HGT = seq(150,190,by=10), MALE = c(TRUE,TRUE,FALSE,FALSE,FALSE))
sample_iiv(poppkmod(data = data, drug = "ppf", model = "eleveld"))
}
