% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{bracket_expr}
\alias{bracket_expr}
\title{Expressions in Brackets}
\usage{
bracket_expr(exprs)
}
\arguments{
\item{exprs}{(\code{list} of \code{call})\cr expressions to concatenate into
a single \emph{bracketed} expression.}
}
\value{
a \verb{\{} object. See \code{\link[base:Paren]{base::Paren()}} for details.
}
\description{
Groups several expressions in a single \emph{bracketed} expression.
}
\examples{
adsl <- tmc_ex_adsl
adrs <- tmc_ex_adrs

expr1 <- substitute(
  expr = anl <- subset(df, PARAMCD == param),
  env = list(df = as.name("adrs"), param = "INVET")
)
expr2 <- substitute(expr = anl$rsp_lab <- d_onco_rsp_label(anl$AVALC))
expr3 <- substitute(
  expr = {
    anl$is_rsp <- anl$rsp_lab \%in\%
      c("Complete Response (CR)", "Partial Response (PR)")
  }
)

res <- bracket_expr(list(expr1, expr2, expr3))
eval(res)
table(anl$rsp_lab, anl$is_rsp)

}
