% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tm_g_ipp.R
\name{tm_g_ipp}
\alias{tm_g_ipp}
\title{teal Module: Individual Patient Plots}
\usage{
tm_g_ipp(
  label,
  dataname,
  parentname = ifelse(inherits(arm_var, "data_extract_spec"),
    teal.transform::datanames_input(arm_var), "ADSL"),
  arm_var,
  paramcd,
  id_var = teal.transform::choices_selected(teal.transform::variable_choices(dataname,
    "USUBJID"), "USUBJID", fixed = TRUE),
  visit_var = teal.transform::choices_selected(teal.transform::variable_choices(dataname,
    "AVISIT"), "AVISIT", fixed = TRUE),
  aval_var = teal.transform::choices_selected(teal.transform::variable_choices(dataname,
    "AVAL"), "AVAL", fixed = TRUE),
  avalu_var = teal.transform::choices_selected(teal.transform::variable_choices(dataname,
    "AVALU"), "AVALU", fixed = TRUE),
  base_var = lifecycle::deprecated(),
  baseline_var =
    teal.transform::choices_selected(teal.transform::variable_choices(dataname, "BASE"),
    "BASE", fixed = TRUE),
  add_baseline_hline = FALSE,
  separate_by_obs = FALSE,
  suppress_legend = FALSE,
  add_avalu = TRUE,
  plot_height = c(1200L, 400L, 5000L),
  plot_width = NULL,
  pre_output = NULL,
  post_output = NULL,
  ggplot2_args = teal.widgets::ggplot2_args(),
  transformators = list(),
  decorators = list()
)
}
\arguments{
\item{label}{(\code{character})\cr menu item label of the module in the teal app.}

\item{dataname}{(\code{character})\cr analysis data used in teal module.}

\item{parentname}{(\code{character})\cr parent analysis data used in teal module, usually this refers to \code{ADSL}.}

\item{arm_var}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with
all available choices and preselected option for variable values that can be used as arm variable.}

\item{paramcd}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with all
available choices and preselected option for the parameter code variable from \code{dataname}.}

\item{id_var}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object specifying
the variable name for subject id.}

\item{visit_var}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with
all available choices and preselected option for variable names that can be used as \code{visit} variable.
Must be a factor in \code{dataname}.}

\item{aval_var}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with
all available choices and pre-selected option for the analysis variable.}

\item{avalu_var}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with
all available choices and preselected option for the analysis unit variable.}

\item{base_var}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} Please use the \code{baseline_var} argument instead.}

\item{baseline_var}{(\code{\link[teal.transform:choices_selected]{teal.transform::choices_selected()}})\cr object with
all available choices and preselected option for variable values that can be used as \code{baseline_var}.}

\item{add_baseline_hline}{(\code{logical})\cr whether a horizontal line should be added to the plot at baseline y-value.}

\item{separate_by_obs}{(\code{logical})\cr whether to create multi-panel plots.}

\item{suppress_legend}{(\code{logical})\cr whether to suppress the plot legend.}

\item{add_avalu}{(\code{logical})\cr whether \code{avalu_first} text should be appended to the plot title and y-axis label.}

\item{plot_height}{(\code{numeric}) optional\cr vector of length three with \code{c(value, min, max)}. Specifies the
height of the main plot and renders a slider on the plot to interactively adjust the plot height.}

\item{plot_width}{(\code{numeric}) optional\cr vector of length three with \code{c(value, min, max)}. Specifies the width
of the main plot and renders a slider on the plot to interactively adjust the plot width.}

\item{pre_output}{(\code{shiny.tag}) optional,\cr with text placed before the output to put the output into context.
For example a title.}

\item{post_output}{(\code{shiny.tag}) optional,\cr with text placed after the output to put the output into context.
For example the \code{\link[shiny:helpText]{shiny::helpText()}} elements are useful.}

\item{ggplot2_args}{(\code{ggplot2_args}) optional\cr object created by \code{\link[teal.widgets:ggplot2_args]{teal.widgets::ggplot2_args()}} with settings
for the module plot. For this module, this argument will only accept \code{ggplot2_args} object with \code{labs} list of
the following child elements: \code{title}, \code{subtitle}, \code{x}, \code{y}. No other elements are taken into account. The
argument is merged with option \code{teal.ggplot2_args} and with default module arguments (hard coded in the module
body).

For more details, see the vignette: \code{vignette("custom-ggplot2-arguments", package = "teal.widgets")}.}

\item{transformators}{(\code{list} of \code{teal_transform_module}) that will be applied to transform module's data input.
To learn more check \code{vignette("transform-input-data", package = "teal")}.}

\item{decorators}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
(named \code{list} of lists of \code{teal_transform_module}) optional,
decorator for tables or plots included in the module output reported.
The decorators are applied to the respective output objects.

See section "Decorating Module" below for more details.}
}
\value{
a \code{teal_module} object.
}
\description{
This module produces \code{\link[ggplot2:ggplot]{ggplot2::ggplot()}} type individual patient plots that display trends in parameter
values over time for each patient, using data with ADaM structure.
}
\section{Decorating Module}{


This module generates the following objects, which can be modified in place using decorators:
\itemize{
\item \code{plot} (\code{ggplot})
}

A Decorator is applied to the specific output using a named list of \code{teal_transform_module} objects.
The name of this list corresponds to the name of the output to which the decorator is applied.
See code snippet below:

\if{html}{\out{<div class="sourceCode">}}\preformatted{tm_g_ipp(
   ..., # arguments for module
   decorators = list(
     plot = teal_transform_module(...) # applied only to `plot` output
   )
)
}\if{html}{\out{</div>}}

For additional details and examples of decorators, refer to the vignette
\code{vignette("decorate-module-output", package = "teal.modules.clinical")}.

To learn more please refer to the vignette
\code{vignette("transform-module-output", package = "teal")} or the \code{\link[teal:teal_transform_module]{teal::teal_transform_module()}} documentation.
}

\examples{
library(nestcolor)
library(dplyr)

data <- teal_data()
data <- within(data, {
  ADSL <- tmc_ex_adsl \%>\%
    slice(1:20) \%>\%
    df_explicit_na()
  ADLB <- tmc_ex_adlb \%>\%
    filter(USUBJID \%in\% ADSL$USUBJID) \%>\%
    df_explicit_na() \%>\%
    filter(AVISIT != "SCREENING")
})
join_keys(data) <- default_cdisc_join_keys[names(data)]

ADSL <- data[["ADSL"]]
ADLB <- data[["ADLB"]]

app <- init(
  data = data,
  modules = modules(
    tm_g_ipp(
      label = "Individual Patient Plot",
      dataname = "ADLB",
      arm_var = choices_selected(
        value_choices(ADLB, "ARMCD"),
        "ARM A"
      ),
      paramcd = choices_selected(
        value_choices(ADLB, "PARAMCD"),
        "ALT"
      ),
      aval_var = choices_selected(
        variable_choices(ADLB, c("AVAL", "CHG")),
        "AVAL"
      ),
      avalu_var = choices_selected(
        variable_choices(ADLB, c("AVALU")),
        "AVALU",
        fixed = TRUE
      ),
      id_var = choices_selected(
        variable_choices(ADLB, c("USUBJID")),
        "USUBJID",
        fixed = TRUE
      ),
      visit_var = choices_selected(
        variable_choices(ADLB, c("AVISIT")),
        "AVISIT"
      ),
      baseline_var = choices_selected(
        variable_choices(ADLB, c("BASE")),
        "BASE",
        fixed = TRUE
      ),
      add_baseline_hline = FALSE,
      separate_by_obs = FALSE
    )
  )
)
if (interactive()) {
  shinyApp(app$ui, app$server)
}

}
\seealso{
The \href{https://insightsengineering.github.io/tlg-catalog/stable/}{TLG Catalog} where additional example
apps implementing this module can be found.
}
\section{Examples in Shinylive}{
\describe{
  \item{example-1}{
    \href{https://shinylive.io/r/app/#code=NobwRAdghgtgpmAXGKAHVA6ASmANGAYwHsIAXOMpMAGwEsAjAJykYE8AKcqajGIgEwCu1OAGcMBOhFoFuASgA60snGYFStAG5wABAB4AtDoBmgiOtol2cnQBUsAVQCiSpXSYsOEMaWLUijIoQ7sxs7Pyo1KyBrhD8UKRQ+kZc1AD68YnWSplJhjoA7rSkABa0EOEJULg6IEo6OgCCACIAygAyyTqkMARpcAAeaVD8otQ6AKQAfBP1DTpjMnDsAIyIAEwADDbTsxDzOvzG-QORMsVp0Nn7Tc3tAEJdPX2Dw-zU9JMzcw3GtNTkRjsBytBz3ABSAElmpNyhNbh0ACQgsFQ5o7b43BpHE5nAgXK4YvYHP4A1TsRoANUhrUhth0AEIALw6BRgVoAYSwTicADlIbyAOJsoIAXyCACsiOU0gBrOCsUSVRI2fL8ODGKDCUhpAj8WiiPpSmXyxXAaDwJW5OQAXViLQ6XVywGAbId7TZNrtEBaDydVRdbru9093qUaFQXXKxXYc1yOhZuVwcz4QhEogTOlTwjEsax3RgaQA5mlaOg8wcGtQoPQ4OMWWzIXEtLQhNwdAAFBK0CikTv+Uhs5P57FVC26BtgX0hvA-eYsQuaFiZgglaUEMRpUR1uDqOD8CuVhpL6iCOC6tdLJXTmpurAAWQ5zRFw6PDTv96abLnDTkr8rqAsLAeorpeG6iFuO57geP7zCeZ4XuuuY3qyYAdo0WCNI+z5gH+sHvlO7S2N+I46HhpFQCeaRLowoFIRB24iNBh5HjRtA1iIiFXhSwY1AQsZTpSjQengqEcgAEsKuHkW+qFUsJJFHjJlaUdwgjUcuLKrvRkFMeQMGkceLDsfQnHadxKH8W6QntA4IrKUe1nCXZs6GSYtADPumb2M4sEOfMrYabRWlgZujG7vpLGVmxHHnuZ4E8Q8fECSiELQvZ-6OWAqVokO+HuZ5-DeY4Likf5x4GhcNF0VeukRfuUUHDFplxaF168ToVmCTSdIZfl1k9cRYB+Zl8z0FAjHlOe1UhTp4XMflzVmW1iX3MlbL3I0rQuNJo0HBtW07Xt8x-IVxW+WVx0jPwaTjZN3hpCUUgTjoABiwnbcd26Acw5C3awaREPQGYsu97TbXOQS-koQS0MYOjsOUgJQBY2jWDYdQ3KIZQQKwjTlhGiKCLQNSE9ujDaDEECikoYCijaQA}{Open in Shinylive}
    \if{html}{\out{<iframe class="iframe_shinylive" src="https://shinylive.io/r/app/#code=NobwRAdghgtgpmAXGKAHVA6ASmANGAYwHsIAXOMpMAGwEsAjAJykYE8AKcqajGIgEwCu1OAGcMBOhFoFuASgA60snGYFStAG5wABAB4AtDoBmgiOtol2cnQBUsAVQCiSpXSYsOEMaWLUijIoQ7sxs7Pyo1KyBrhD8UKRQ+kZc1AD68YnWSplJhjoA7rSkABa0EOEJULg6IEo6OgCCACIAygAyyTqkMARpcAAeaVD8otQ6AKQAfBP1DTpjMnDsAIyIAEwADDbTsxDzOvzG-QORMsVp0Nn7Tc3tAEJdPX2Dw-zU9JMzcw3GtNTkRjsBytBz3ABSAElmpNyhNbh0ACQgsFQ5o7b43BpHE5nAgXK4YvYHP4A1TsRoANUhrUhth0AEIALw6BRgVoAYSwTicADlIbyAOJsoIAXyCACsiOU0gBrOCsUSVRI2fL8ODGKDCUhpAj8WiiPpSmXyxXAaDwJW5OQAXViLQ6XVywGAbId7TZNrtEBaDydVRdbru9093qUaFQXXKxXYc1yOhZuVwcz4QhEogTOlTwjEsax3RgaQA5mlaOg8wcGtQoPQ4OMWWzIXEtLQhNwdAAFBK0CikTv+Uhs5P57FVC26BtgX0hvA-eYsQuaFiZgglaUEMRpUR1uDqOD8CuVhpL6iCOC6tdLJXTmpurAAWQ5zRFw6PDTv96abLnDTkr8rqAsLAeorpeG6iFuO57geP7zCeZ4XuuuY3qyYAdo0WCNI+z5gH+sHvlO7S2N+I46HhpFQCeaRLowoFIRB24iNBh5HjRtA1iIiFXhSwY1AQsZTpSjQengqEcgAEsKuHkW+qFUsJJFHjJlaUdwgjUcuLKrvRkFMeQMGkceLDsfQnHadxKH8W6QntA4IrKUe1nCXZs6GSYtADPumb2M4sEOfMrYabRWlgZujG7vpLGVmxHHnuZ4E8Q8fECSiELQvZ-6OWAqVokO+HuZ5-DeY4Likf5x4GhcNF0VeukRfuUUHDFplxaF168ToVmCTSdIZfl1k9cRYB+Zl8z0FAjHlOe1UhTp4XMflzVmW1iX3MlbL3I0rQuNJo0HBtW07Xt8x-IVxW+WVx0jPwaTjZN3hpCUUgTjoABiwnbcd26Acw5C3awaREPQGYsu97TbXOQS-koQS0MYOjsOUgJQBY2jWDYdQ3KIZQQKwjTlhGiKCLQNSE9ujDaDEECikoYCijaQA" style="height: 800px; width: 100vw; max-width: 1400px; border: 1px solid rgba(0,0,0,0.175); border-radius: .375rem; position: absolute; left: 50\%; margin-top: 30px; transform: translateX(-50\%); z-index: 1"></iframe>}}
    \if{html}{\out{<a style='height: 800px; display: block;'></a>}}
  }
}
}

