% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{check_modules_datanames}
\alias{check_modules_datanames}
\alias{check_reserved_datanames}
\alias{check_modules_datanames_html}
\title{Check \code{datanames} in modules}
\usage{
check_modules_datanames(modules, datanames)

check_reserved_datanames(datanames)

check_modules_datanames_html(modules, datanames)
}
\arguments{
\item{modules}{(\code{teal_modules}) object}

\item{datanames}{(\code{character}) names of datasets available in the \code{data} object}
}
\value{
\code{TRUE} if validation passes, otherwise \code{character(1)} or \code{shiny.tag.list}
}
\description{
These functions check if specified \code{datanames} in modules match those in the data object,
returning error messages or \code{TRUE} for successful validation. Two functions return error message
in different forms:
\itemize{
\item \code{check_modules_datanames} returns \code{character(1)} for basic assertion usage
\item \code{check_modules_datanames_html} returns \code{shiny.tag.list} to display it in the app.
}
}
\keyword{internal}
