% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mergeCovmat.R
\name{mergeCovmat}
\alias{mergeCovmat}
\title{Combine sample covariance matrices from two samples}
\usage{
mergeCovmat(
  A.cov.xy,
  B.cov.xy,
  A.mean.x,
  A.mean.y,
  B.mean.x,
  B.mean.y,
  A.n,
  B.n
)
}
\arguments{
\item{A.cov.xy}{sample covariance matrix from the first sample, 'A'}

\item{B.cov.xy}{sample covariance matrix from the second sample, 'B'}

\item{A.mean.x}{sample mean from the first sample, 'A'}

\item{A.mean.y}{sample mean from the first sample, 'A'}

\item{B.mean.x}{sample mean from the second sample, 'B'}

\item{B.mean.y}{sample mean from the second sample, 'B'}

\item{A.n}{sample size from the first sample, 'A'}

\item{B.n}{sample size from the second sample, 'B'}
}
\description{
This function combines the sample covariance information from two samples (of 
the same phenomena) to return the sample covariance matric of the union of 
the two samples.
}
\details{
This function assumes the data is normalized by n (the MLE estimator) 
instead of n-1 (the unbiased estimator).
}
\references{
Pebay, P., 2008, Formulas for Robust, One-Pass Parallel Computation of Covariances and Arbitrary-Order Statistical Moments: Sandia Report.
}
