% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{unnest_fun}
\alias{unnest_fun}
\title{Unnest a list-column}
\usage{
unnest_fun(data, cols, keep_empty = FALSE)
}
\arguments{
\item{data}{A data frame.}

\item{cols}{Columns to unnest.}

\item{keep_empty}{By default, you get one row of output for each element of the list your unchopping/unnesting.
This means that if there's a size-0 element (like \code{NULL} or an empty data frame),
that entire row will be dropped from the output.
If you want to preserve all rows,
use \code{keep_empty = TRUE} to replace size-0 elements with a single row of missing values.}
}
\description{
Implement similar functions to the \link[tidyr:unnest]{tidyr::unnest} function.
}
\examples{
data <- data.frame(
  id = 1:3,
  x = c("a", "b", "c"),
  stringsAsFactors = FALSE
)
data$data <- list(
  c(1, 2),
  c(3, 4, 5),
  c(6)
)
unnest_fun(data, cols = "data")

data2 <- data.frame(
  id = 1:3,
  x = c("a", "b", "c"),
  stringsAsFactors = FALSE
)
data2$data <- list(
  c(1, 2),
  numeric(0),
  c(6)
)
unnest_fun(data2, cols = "data")
unnest_fun(data2, cols = "data", keep_empty = TRUE)
}
