% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ic_weights.R
\name{ic_weights}
\alias{ic_weights}
\title{Compare Information Criteria}
\usage{
ic_weights(x, ...)
}
\arguments{
\item{x}{An object for which a method exists.}

\item{...}{Additional arguments.}
}
\value{
A \code{list} of class \code{ic_weights} with elements \verb{$weights}, which
contains the model weights, and \verb{$comparison}, which contains the relative
support in favor of each model over the others.
}
\description{
IC weights quantify the evidence in favor of different models in a set.
This function normalizes the IC values to obtain IC weights, which sum to 1.
The model with the highest weight is most supported by the data.
The ratio of different weights gives the relative support in favor of one
model over another.
}
\examples{
ics <- c(100, 200, 102, 300)
ic_weights(ics)
}
\references{
Wagenmakers, E. J., & Farrell, S. (2004). AIC model selection
using Akaike weights. Psychonomic bulletin & review, 11(1), 192-196.
\doi{10.3758/BF03206482}
}
