% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/joint-effect-estimation.R
\name{fit_fx_predictor}
\alias{fit_fx_predictor}
\title{Fit a predictor for treatment effects}
\usage{
fit_fx_predictor(full_data, weights, psi_col, ..., .pcate.cfg, .Model_cfg)
}
\arguments{
\item{full_data}{The full original data with all auxilliary columns.}

\item{weights}{Weights to be used in the analysis.}

\item{psi_col}{The unquoted column name of the calculated pseudo-outcome.}

\item{...}{Covariate data, passed in as the unquoted names of columns in \code{full_data}}

\item{.pcate.cfg}{A \code{PCATE_cfg} object describing what PCATEs to calculate (and how)}

\item{.Model_cfg}{A \code{Model_cfg} object describing how the effect model should be estimated.}
}
\value{
A list with two items:
\itemize{
\item \code{model} - The \code{FX.Predictor} model object used internally for PCATE estimation.
\item \code{data} - The data augmented with column \code{.pseudo_outcome_hat} for the cross-fit predictions
of the HTE for each unit.
}
}
\description{
This function predicts treatment effects in a second stage model.
}
\seealso{
\link{Model_cfg}, \link{PCATE_cfg}
}
\keyword{internal}
