% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vec-standardize.R
\name{standardize_vec}
\alias{standardize_vec}
\alias{standardize_inv_vec}
\title{Standardize to Mean 0, Standard Deviation 1 (Center & Scale)}
\usage{
standardize_vec(x, mean = NULL, sd = NULL, silent = FALSE)

standardize_inv_vec(x, mean, sd)
}
\arguments{
\item{x}{A numeric vector.}

\item{mean}{The mean used to invert the standardization}

\item{sd}{The standard deviation used to invert the standardization process.}

\item{silent}{Whether or not to report the automated \code{mean} and \code{sd} parameters as a message.}
}
\value{
Returns a \code{numeric} vector with the standardization transformation applied.
}
\description{
Standardization is commonly used to center and scale numeric features to prevent one from
dominating in algorithms that require data to be on the same scale.
}
\details{
\strong{Standardization vs Normalization}
\itemize{
\item \strong{Standardization} refers to a transformation that reduces the range to
mean 0, standard deviation 1
\item \strong{Normalization} refers to a transformation that reduces the min-max range: (0, 1)
}
}
\examples{
library(dplyr)

d10_daily <- m4_daily \%>\% dplyr::filter(id == "D10")

# --- VECTOR ----

value_std <- standardize_vec(d10_daily$value)
value     <- standardize_inv_vec(value_std,
                                 mean = 2261.60682492582,
                                 sd   = 175.603721730477)

# --- MUTATE ----

m4_daily \%>\%
    group_by(id) \%>\%
    mutate(value_std = standardize_vec(value))

}
\seealso{
\itemize{
\item Normalization/Standardization: \code{\link[=standardize_vec]{standardize_vec()}}, \code{\link[=normalize_vec]{normalize_vec()}}
\item Box Cox Transformation: \code{\link[=box_cox_vec]{box_cox_vec()}}
\item Lag Transformation: \code{\link[=lag_vec]{lag_vec()}}
\item Differencing Transformation: \code{\link[=diff_vec]{diff_vec()}}
\item Rolling Window Transformation: \code{\link[=slidify_vec]{slidify_vec()}}
\item Loess Smoothing Transformation: \code{\link[=smooth_vec]{smooth_vec()}}
\item Fourier Series: \code{\link[=fourier_vec]{fourier_vec()}}
\item Missing Value Imputation for Time Series: \code{\link[=ts_impute_vec]{ts_impute_vec()}}, \code{\link[=ts_clean_vec]{ts_clean_vec()}}
}
}
