% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/save_tt.R, R/zzz-aliases.R
\name{save_tt}
\alias{save_tt}
\alias{tt_save}
\title{Save a Tiny Table to File}
\usage{
save_tt(
  x,
  output = get_option("tinytable_save_output", default = NULL),
  overwrite = get_option("tinytable_save_overwrite", default = FALSE)
)

tt_save(
  x,
  output = get_option("tinytable_save_output", default = NULL),
  overwrite = get_option("tinytable_save_overwrite", default = FALSE)
)
}
\arguments{
\item{x}{The tinytable object to be saved.}

\item{output}{String or file path.
\itemize{
\item If \code{output} is "markdown", "latex", "html", "html_portable", "typst", or "tabulator", the table is returned in a string as an \code{R} object.
\item If \code{output} is a valid file path, the table is saved to file. The supported extensions are: .docx, .html, .png, .pdf, .tex, .typ, and .md (with aliases .txt, .Rmd and .qmd).
\item If \code{output} is "html_portable" or the global option \code{tinytable_html_portable} is \code{TRUE},
the images are included in the HTML as base64 encoded string instead of link to a local file.
}}

\item{overwrite}{A logical value indicating whether to overwrite an existing file.}
}
\value{
A string with the table when \code{output} is a format, and the file path when \code{output} is a valid path.
}
\description{
This function saves an object of class tinytable to a specified file and format, with an option to overwrite existing files.
}
\section{Dependencies}{

\itemize{
\item \code{.pdf} output requires a full LaTeX installation on the local computer.
\item \code{.png} output requires the \code{webshot2} package.
\item \code{.html} self-contained files require the \code{base64enc} package.
}
}

\section{LaTeX preamble}{


\code{tinytable} uses the \code{tabularray} package from your LaTeX distribution to draw tables. \code{tabularray}, in turn, uses the special \code{tblr}, \code{talltblr}, and \code{longtblr} environments.

When rendering a document from Quarto or Rmarkdown directly to PDF, \code{tinytable} will populate the LaTeX preamble automatically with all the required packages. For standalone LaTeX documents, these commands should be inserted in the preamble manually:

Note: Your document will fail to compile to PDF in Quarto if you enable caching and you use tinytable due to missing LaTeX headers. To avoid this problem, set the option \verb{#| cache: false} for the chunk(s) where you use tinytable.

\if{html}{\out{<div class="sourceCode latex">}}\preformatted{\\usepackage\{tabularray\}
\\usepackage\{float\}
\\usepackage\{graphicx\}
\\usepackage\{rotating\}
\\usepackage[normalem]\{ulem\}
\\UseTblrLibrary\{booktabs\}
\\UseTblrLibrary\{siunitx\}
\newcommand{\tinytableTabularrayUnderline}[1]\{\\underline\{#1\}\}
\newcommand{\tinytableTabularrayStrikeout}[1]\{\\sout\{#1\}\}
\\NewTableCommand\{\\tinytableDefineColor\}[3]\{\\definecolor\{#1\}\{#2\}\{#3\}\}
}\if{html}{\out{</div>}}
}

\section{Global options}{


Options can be set with \code{options()} and change the default behavior of tinytable. For example:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{options(tinytable_tt_digits = 4)
tt(head(iris))
}\if{html}{\out{</div>}}

You can set options in a script or via \code{.Rprofile}. Note: be cautious with \code{.Rprofile} settings as they may affect reproducibility.
\subsection{Default values for function arguments}{

Nearly all of the package's functions retrieve their default values from global options. This allows you to set defaults once and apply them to all tables without needing to specify them each time. For example, to fix the the \code{digits} argument of the \code{tt()} function globally, call:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{options(tinytable_tt_digits = 4)
}\if{html}{\out{</div>}}

In addition, some more specific options are available to control the behavior of the package in specific contexts.
\subsection{HTML}{
\itemize{
\item \code{tinytable_html_mathjax}: Insert MathJax scripts (warning: may conflict if MathJax is loaded elsewhere)
\item \code{tinytable_html_portable}: Insert base64 encoded images directly in HTML for \code{plot_tt()}
\item \code{tinytable_html_engine}: Default HTML engine (default: "bootstrap"). Set to "tabulator" to use interactive tables by default in HTML documents instead of static Bootstrap tables.
}
}

\subsection{PDF}{
\itemize{
\item \code{tinytable_pdf_clean}: Delete temporary and log files
\item \code{tinytable_pdf_engine}: Choose between "xelatex", "pdflatex", "lualatex"
}
}

\subsection{Color processing}{
\itemize{
\item \code{tinytable_color_name_normalization}: Enable/disable automatic color name processing (default: TRUE).
}

When enabled, R color names recognized by \code{col2rgb()} are converted to hex format for consistent rendering across HTML, LaTeX, and Typst formats. If R color conversion fails, LaTeX color names are used as fallback. Colors explicitly supplied as hex values with "#" prefix are passed through unchanged. Set to FALSE to disable processing and pass color names unchanged.
}

\subsection{Quarto}{

The \code{format_tt(quarto=TRUE)} argument enables Quarto data processing with some limitations:
\enumerate{
\item The \verb{\\QuartoMarkdownBase64\{\}} LaTeX macro may not process references and markdown as expected
\item Quarto processing may conflict with \code{tinytable} styling/formatting
}

Options:
\itemize{
\item \code{tinytable_quarto_disable_processing}: Disable Quarto cell processing
\item \code{tinytable_print_rstudio_notebook}: Display tables "inline" or in "viewer" for RStudio notebooks
\item \code{tinytable_quarto_figure}: Control Typst figure environment in Quarto
}

Example of Quarto-specific code in cells:

\if{html}{\out{<div class="sourceCode r">}}\preformatted{x <- data.frame(Math = "x^2^", Citation = "@Lovelace1842")
fn <- function(z) sprintf("<span data-qmd='\%s'></span>", z)
tt(x) |> format_tt(i = 1, fn = fn)
}\if{html}{\out{</div>}}

For more details on Quarto table processing: https://quarto.org/docs/authoring/tables.html#disabling-quarto-table-processing
}

}
}

\examples{
library(tinytable)
x <- mtcars[1:4, 1:5]

fn <- file.path(tempdir(), "test.html")
tt(x) |> save_tt(fn, overwrite = TRUE)

library(tinytable)
filename <- file.path(tempdir(), "table.tex")
tt(mtcars[1:4, 1:4]) |> save_tt(filename)

}
