% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linalg.R
\name{linalg_cond}
\alias{linalg_cond}
\title{Computes the condition number of a matrix with respect to a matrix norm.}
\usage{
linalg_cond(A, p = NULL)
}
\arguments{
\item{A}{(Tensor): tensor of shape \verb{(*, m, n)} where \code{*} is zero or more batch dimensions
for \code{p} in \verb{(2, -2)}, and of shape \verb{(*, n, n)} where every matrix
is invertible for \code{p} in \verb{('fro', 'nuc', inf, -inf, 1, -1)}.}

\item{p}{(int, inf, -inf, 'fro', 'nuc', optional):
the type of the matrix norm to use in the computations (see above). Default: \code{NULL}}
}
\value{
A real-valued tensor, even when \code{A} is complex.
}
\description{
Letting \teqn{\mathbb{K}} be \teqn{\mathbb{R}} or \teqn{\mathbb{C}},
the \strong{condition number} \teqn{\kappa} of a matrix
\teqn{A \in \mathbb{K}^{n \times n}} is defined as
}
\details{
\Sexpr[results=rd, stage=build]{torch:::math_to_rd("\\\\kappa(A) = \\\\|A\\\\|_p\\\\|A^{-1}\\\\|_p")}

The condition number of \code{A} measures the numerical stability of the linear system \code{AX = B}
with respect to a matrix norm.

Supports input of float, double, cfloat and cdouble dtypes.
Also supports batches of matrices, and if \code{A} is a batch of matrices then
the output has the same batch dimensions.

\code{p} defines the matrix norm that is computed. See the table in 'Details' to
find the supported norms.

For \code{p} is one of \verb{('fro', 'nuc', inf, -inf, 1, -1)}, this function uses
\code{\link[=linalg_norm]{linalg_norm()}} and \code{\link[=linalg_inv]{linalg_inv()}}.

As such, in this case, the matrix (or every matrix in the batch) \code{A} has to be square
and invertible.

For \code{p} in \verb{(2, -2)}, this function can be computed in terms of the singular values
\teqn{\sigma_1 \geq \ldots \geq \sigma_n}

\Sexpr[results=rd, stage=build]{torch:::math_to_rd("\\\\kappa_2(A) = \\\\frac{\\\\sigma_1}{\\\\sigma_n}\\\\qquad \\\\kappa_{-2}(A) = \\\\frac{\\\\sigma_n}{\\\\sigma_1}")}

In these cases, it is computed using \code{\link[=linalg_svd]{linalg_svd()}}. For these norms, the matrix
(or every matrix in the batch) \code{A} may have any shape.

\tabular{ll}{
   \code{p} \tab matrix norm \cr
   \code{NULL} \tab \code{2}-norm (largest singular value) \cr
   \code{'fro'} \tab Frobenius norm \cr
   \code{'nuc'} \tab nuclear norm \cr
   \code{Inf} \tab \code{max(sum(abs(x), dim=2))} \cr
   \code{-Inf} \tab \code{min(sum(abs(x), dim=2))} \cr
   \code{1} \tab \code{max(sum(abs(x), dim=1))} \cr
   \code{-1} \tab \code{min(sum(abs(x), dim=1))} \cr
   \code{2} \tab largest singular value \cr
   \code{-2} \tab smallest singular value \cr
}
}
\note{
When inputs are on a CUDA device, this function synchronizes that device with the CPU if
if \code{p} is one of \verb{('fro', 'nuc', inf, -inf, 1, -1)}.
}
\examples{
if (torch_is_installed()) {
a <- torch_tensor(rbind(c(1., 0, -1), c(0, 1, 0), c(1, 0, 1)))
linalg_cond(a)
linalg_cond(a, "fro")
}
}
