% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preptdc.R
\name{preptdc}
\alias{preptdc}
\title{Prepare Survival Data With Time-Dependent Covariates}
\usage{
preptdc(
  adsl,
  adtdc,
  id = "SUBJID",
  randdt = "RANDDT",
  trtsdt = "TRTSDT",
  pddt = "PDDT",
  xodt = "XODT",
  osdt = "OSDT",
  died = "DIED",
  dcutdt = "DCUTDT",
  adt = "ADT",
  paramcd = "PARAMCD",
  aval = "AVAL",
  nodup = TRUE,
  offset = TRUE
)
}
\arguments{
\item{adsl}{A data set containing baseline subject-level information.
It should include, at a minimum, subject ID (\code{id}),
randomization date (\code{randdt}), treatment start date (\code{trtsdt}),
survival outcome (\code{osdt}, \code{died}), progression date (\code{pddt}),
treatment switch date (\code{xodt}), and data cut-off date (\code{dcutdt}).}

\item{adtdc}{A data set containing longitudinal
time-dependent covariate data, with subject ID (\code{id}),
parameter code (\code{paramcd}), analysis date (\code{adt}), and covariate
value (\code{aval}).}

\item{id}{Character string specifying the column name for subject ID.}

\item{randdt}{Character string specifying the column name for
randomization date.}

\item{trtsdt}{Character string specifying the column name for
treatment start date.}

\item{pddt}{Character string specifying the column name for progression
date.}

\item{xodt}{Character string specifying the column name for treatment
crossover/switch date.}

\item{osdt}{Character string specifying the column name for overall
survival date (death date or last known alive date).}

\item{died}{Character string specifying the column name for death
indicator (0 = alive/censored, 1 = died).}

\item{dcutdt}{Character string specifying the column name for data
cut-off date.}

\item{adt}{Character string specifying the column name for analysis
date in the time-dependent covariate dataset.}

\item{paramcd}{Character string specifying the column name for parameter
code (identifying different covariates).}

\item{aval}{Character string specifying the column name for analysis
value (covariate values).}

\item{nodup}{Logical; if \code{TRUE} (default), only rows where at least
one covariate changes compared to the previous row (within each subject)
are retained, along with the first row per subject (baseline).}

\item{offset}{Logical; if \code{TRUE} (default), add 1-day offset when
computing analysis day variables (\code{ady}, \code{osdy}, etc.).}
}
\value{
A data set with one row per subject and time interval, including:
\itemize{
\item \code{tstart}, \code{tstop} — interval start and stop times
(days from randomization).
\item \code{event} — event indicator (0/1).
\item Covariates expanded to wide format.
\item Auxiliary variables such as progression indicator (\code{pd}),
treatment switch indicator (\code{swtrt}), and administrative
censoring time.
}
}
\description{
This function prepares a counting-process style survival dataset
for analyses with time-dependent covariates. It merges baseline
and longitudinal data, fills in missing covariate values using
last-observation-carried-forward (LOCF), restricts to time points
where covariates change (optional), and constructs \code{tstart}, \code{tstop},
and \code{event} variables suitable for use in survival models.
}
\details{
The function performs the following steps:
\enumerate{
\item Merge \code{adsl} and \code{adtdc} to obtain randomization date and
treatment start date.
\item Define \code{adt2} as \code{adt} if \code{adt > trtsdt},
and \code{randdt} if \code{adt <= trtsdt} (i.e., baseline time point).
This ensures that the baseline covariate value is the last
non-missing value at or before the treatment start date.
Post-baseline covariate values are anchored at their actual
analysis dates.
\item Keep the last record per subject, \code{adt2}, and \code{paramcd}.
\item Construct a complete skeleton so all covariates are present
for each subject and time point.
\item Fill missing covariate values using LOCF.
\item Pivot to wide format with one row per subject and time point.
\item Optionally drop rows without covariate changes (\code{nodup = TRUE}).
\item Merge survival outcomes from \code{adsl}.
\item Compute time-to-event variables (\code{ady}, \code{osdy}, etc.), as well as
counting-process style variables \code{tstart}, \code{tstop}, and \code{event}.
}
}
\examples{

surv_data <- preptdc(adsl, adtdc, nodup = TRUE)
head(surv_data)

}
