% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tsforecast_1.2.0.R
\name{ts-functions}
\alias{ts-functions}
\alias{tsfreq}
\alias{tstime}
\alias{tstimegap}
\alias{tsname}
\alias{tsattrcopy}
\title{Extract Information of a Time Series}
\usage{
## Extract frequency of a time series
tsfreq(x)

## Extract observation time periods of a time series
tstime(x)

## Extract time gaps between a time series' observations
tstimegap(t)

## Get or set the name of a time series
tsname(x, x.name = NULL)

## Copy Attributes from a Time Series to Another
tsattrcopy(x, x.orig)
}
\arguments{
\item{x}{a univariate time series object or a numeric vector or matrix.}

\item{t}{a vector or list of time in which the series values were observed.}

\item{x.name}{a new name for \code{x}. If the parameter is omitted, the current name of the time series will be returned to the user.}

\item{x.orig}{a univariate time series object whose attributes will be transferred to \code{x}.}
}
\value{
For `\code{tstime}`, a list will be returned to the user with two elements: \code{time} (observation time) and \code{frequnecy} (observation frequency).

For `\code{tsfreq}`, R extracts the attribute `\code{seasonal.cycle}` from the time series object \code{x}.

For `\code{tstimegap}`, R calculates the time gap between the time periods stored in the vector \code{t}.

So, if \code{x} and \code{t} are consistent and refer to the data and time of the same time series, the results of `\code{tsfreq}` and `\code{tstimegap}` as well as the \code{frequnecy} element of `\code{tstime}` must be identical.

If \code{x.name} is \code{NULL}, the attribute \code{series.name} of \code{x} will be returned. Otherwise, the series will be returned with a new value for the attribute \code{series.name} specified by \code{x.name}.

For \code{tsattrcopy}, the function does the same as \code{\link{attributes}}. However, \code{\link{attributes}} only works if both \code{x} and \code{x.orig} share the same length, whereas \code{tsattrcopy} does not require this property and returns \code{x} with all the attributes originated from the series \code{x.orig}.
}
\description{
The function `\code{tsfreq}` extract the frequency of a time series, while `\code{tstime}` extract the time periods in which the series data were observed, and `\code{tstimegap}` returns the time gap between the observations of a time series.

The function `\code{tsname}` can be used to extract or specify the name of a time series.
}
\details{
To set a new name for a time series, the function must be assigned to an object. Otherwise, the new name will not be taken over.
}
\examples{
tsfreq(x = airport$Travellers)
tstime(x = airport$Travellers)
tstimegap(t = airport$Date)
airport$Travellers <- tsname(airport$Travellers, x.name = "Number of Travellers in Airport X")
tsname(airport$Travellers)
tsattrcopy(airport$Travellers[1:60], airport$Travellers)
}
\seealso{
\code{\link{time}}, \code{\link{frequency}}, \code{\link{attributes}}
}
\author{
Ka Yui Karl Wu
}
