% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tuneMtryFast.R
\name{tuneMtryFast}
\alias{tuneMtryFast}
\title{tuneMtryFast}
\usage{
tuneMtryFast(
  formula = NULL,
  data = NULL,
  dependent.variable.name = NULL,
  mtryStart = floor(sqrt(ncol(data) - 1)),
  num.treesTry = 50,
  stepFactor = 2,
  improve = 0.05,
  trace = TRUE,
  plot = TRUE,
  doBest = FALSE,
  ...
)
}
\arguments{
\item{formula}{Object of class formula or character describing the model to fit. Interaction terms supported only for numerical variables.}

\item{data}{Training data of class data.frame, matrix, dgCMatrix (Matrix) or gwaa.data (GenABEL).}

\item{dependent.variable.name}{Name of dependent variable, needed if no formula given. For survival forests this is the time variable.}

\item{mtryStart}{starting value of mtry; default is the same as in \code{\link[ranger]{ranger}}}

\item{num.treesTry}{number of trees used at the tuning step}

\item{stepFactor}{at each iteration, mtry is inflated (or deflated) by this value}

\item{improve}{the (relative) improvement in OOB error must be by this much for the search to continue}

\item{trace}{whether to print the progress of the search}

\item{plot}{whether to plot the OOB error as function of mtry}

\item{doBest}{whether to run a forest using the optimal mtry found}

\item{...}{options to be given to \code{\link[ranger]{ranger}}}
}
\value{
If doBest=FALSE (default), it returns a matrix whose first column contains the mtry values searched, and the second column the corresponding OOB error.

If doBest=TRUE, it returns the \code{\link[ranger]{ranger}} object produced with the optimal mtry.
}
\description{
Similar to tuneRF in \code{\link[randomForest]{randomForest}} but for \code{\link[ranger]{ranger}}.
}
\details{
Provides fast tuning for the mtry hyperparameter. 

Starting with the default value of mtry, search for the optimal value (with respect to Out-of-Bag error estimate) of mtry for randomForest.
}
\examples{
library(tuneRanger)

data(iris)
res <- tuneMtryFast(Species ~ ., data = iris, stepFactor = 1.5)
}
