% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mock_env_data.R
\docType{data}
\name{mock_env_data}
\alias{mock_env_data}
\title{Mock Environmental Data}
\format{
A data frame with 100 rows and 12 variables:
\describe{
\item{date}{POSIXct. Date and time of the observation (hourly increments).}
\item{value}{Numeric. Randomly generated target variable.}
\item{GLO}{Numeric. Global radiation in W/m² (random values between 0 and 1000).}
\item{TMP}{Numeric. Temperature in °C (random values between -10 and 35).}
\item{RFE}{Numeric. Rainfall in mm (random values between 0 and 50).}
\item{WIG}{Numeric. Wind speed in m/s (random values between 0 and 20).}
\item{WIR}{Numeric. Wind direction in degrees (random values between 0 and 360).}
\item{LDR}{Numeric. Longwave downward radiation in W/m² (random values between 0 and 500).}
\item{day_julian}{Integer. Julian day of the year, ranging from 1 to 10.}
\item{weekday}{Integer. Day of the week, ranging from 1 (Monday) to 7 (Sunday).}
\item{hour}{Integer. Hour of the day, ranging from 0 to 23.}
\item{date_unix}{Numeric. UNIX timestamp (seconds since 1970-01-01 00:00:00 UTC).}
}
}
\source{
Generated within the package for example purposes.
}
\usage{
mock_env_data
}
\description{
A small dataset of environmental variables created for testing and examples. This dataset
includes hourly observations with random values for meteorological and temporal variables.
}
\examples{
data(mock_env_data)
head(mock_env_data)
}
\keyword{datasets}
