% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/suspectParticipants.R
\name{suspectParticipants}
\alias{suspectParticipants}
\title{Selects suspect participants from a \code{carelessObject}}
\usage{
suspectParticipants(
  carelessObject,
  nFlags = 1,
  digits = 2,
  missingSymbol = "Missing"
)
}
\arguments{
\item{carelessObject}{The result of the call to
\code{\link[=carelessObject]{carelessObject()}}.}

\item{nFlags}{The number of flags required to be considered
suspect.}

\item{digits}{The number of digits to round to.}

\item{missingSymbol}{How to represent missing values.}
}
\value{
A logical vector.
}
\description{
This function is a wrapper for the \code{\link[=carelessObject]{carelessObject()}}
function, which wraps a number of functions from
the \code{careless} package. Normally, you'd probably
call \code{carelessReport} which calls this function
to generate a report of suspect participants.
}
\examples{
suspectParticipants(carelessObject(mtcars),
                    nFlags = 2);
}
