% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Nottingham.R
\docType{data}
\name{nottingham_2}
\alias{nottingham_2}
\title{Supporting colours of the University of Nottingham, England/UK}
\format{
An object of class \code{character} of length 54.
}
\source{
Colour definitions are based on the UoN's 
\href{https://www.nottingham.ac.uk/brand/visual/colour.aspx}{Colour guidelines}.
}
\usage{
nottingham_2
}
\value{
A named vector of colours (HEX/HTML codes of type character).
}
\description{
\code{nottingham_2} provides the nine supporting colours and five corresponding tints 
(per colour) of the \href{https://www.nottingham.ac.uk}{University of Nottingham}, England/UK.
}
\details{
The supporting colours are accents. They add warmth and vibrancy and can elevate designs.


Inspired by the \href{https://www.nottingham.ac.uk}{University of Nottingham} campus, 
key brand messages and the city of Nottingham, nine colours build up 
the palette to complement the primary \code{Nottingham blue} (see \code{\link{nottingham_1}}).

The supporting palette should be used sparingly,
with a maximum of two supporting colours in any one asset.

Where colour is used within an asset, \code{Nottingham blue} needs to be visually dominant and
the supporting palette should be less than half of the make-up of colour within the asset.

Supporting colours can and should be used for campaigns and initiatives, 
to help audience recognition and aid navigation.

Users must choose the correct colour output for the asset and its usage
(RGB for digital and CMYK for print), as values have been created 
to keep the most vibrancy in print and the best colour representation across digital channels.

Each colour has five tints that can also be used for variety and to assist legibility. 
HEX codes have been provided for each tint, and these should be used when 
creating digital artwork, rather than using opacity.

\code{nottingham_2} uses the HEX color definitions.
}
\examples{
nottingham_2
main_cols <- seq(1, 49, by = 6)
unikn::seecol(nottingham_2[main_cols], main = "Main supporting colors of UoN")

}
\seealso{
\code{\link{nottingham_1}} for primary colours of the University of Nottingham;
\code{\link{nottingham_3}} for neutral colours of the University of Nottingham;
\code{\link{seecol}} for viewing and comparing colour palettes;
\code{\link{usecol}} for using colour palettes;
\code{\link{simcol}} for finding similar colours;
\code{\link{newpal}} for defining new colour palettes;
\code{\link{grepal}} for finding named colours.

Other UK university color palettes: 
\code{\link{nottingham_1}},
\code{\link{nottingham_3}}
}
\author{
\strong{unicol}, 2023-09-04.
}
\concept{UK university color palettes}
\keyword{datasets}
