% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/UCalgary.R
\docType{data}
\name{ucalgary_warmgreys}
\alias{ucalgary_warmgreys}
\title{Warm grey colours of the University of Calgary, Canada}
\format{
An object of class \code{character} of length 2.
}
\source{
Colour definitions are based on \href{https://www.ucalgary.ca}{UCalgary}'s  
\href{https://www.ucalgary.ca/sites/default/files/teams/12/3.0-eyes-high-dec2018.pdf}{Visual identity standards} (PDF).
}
\usage{
ucalgary_warmgreys
}
\value{
A named vector of colours (HEX/HTML codes of type character).
}
\description{
\code{ucalgary_warmgreys} provides the warm greys 
of the \href{https://www.ucalgary.ca}{University of Calgary}, Canada.
}
\details{
The colours are
\code{"light_grey"} (defined as HEX #c4bfb6) and
\code{"dark_grey"} (defined as HEX #8d827a).
}
\examples{
ucalgary_2
unikn::seecol(ucalgary_warmgreys, main = "Warm greys UCalgary") # view colour palette

}
\seealso{
\code{\link{ucalgary_1}} for the primary colours of the University of Calgary;
\code{\link{ucalgary_2}} for the secondary colours of the University of Calgary;
\code{\link{ucalgary_accent}} for the accent colours of the University of Calgary;
\code{\link{seecol}} for viewing and comparing colour palettes;
\code{\link{usecol}} for using colour palettes;
\code{\link{simcol}} for finding similar colours;
\code{\link{newpal}} for defining new colour palettes;
\code{\link{grepal}} for finding named colours.

Other Canadian university color palettes: 
\code{\link{carleton}},
\code{\link{concordia_1}},
\code{\link{concordia_2}},
\code{\link{concordia_3}},
\code{\link{concordia_4}},
\code{\link{guelph}},
\code{\link{laval}},
\code{\link{manitoba_1}},
\code{\link{manitoba_2}},
\code{\link{mcgill_brights}},
\code{\link{mcgill_darks}},
\code{\link{mcgill_grey}},
\code{\link{mcgill_muted}},
\code{\link{mcgill_pastels}},
\code{\link{mcgill_red}},
\code{\link{mcmaster_brighterworld}},
\code{\link{mcmaster_heritage}},
\code{\link{mun_1}},
\code{\link{mun_2}},
\code{\link{queensu_1}},
\code{\link{queensu_2}},
\code{\link{sfu_brand}},
\code{\link{ubc}},
\code{\link{ucalgary_1}},
\code{\link{ucalgary_2}},
\code{\link{ucalgary_accent}},
\code{\link{uottawa}},
\code{\link{utoronto}},
\code{\link{uvic_1}},
\code{\link{uvic_2}},
\code{\link{uwaterloo_arts}},
\code{\link{uwaterloo_engineering}},
\code{\link{uwaterloo_environment}},
\code{\link{uwaterloo_health}},
\code{\link{uwaterloo_main}},
\code{\link{uwaterloo_math}},
\code{\link{uwaterloo_science}},
\code{\link{western_uni}},
\code{\link{yorku_1}},
\code{\link{yorku_2}}
}
\author{
\strong{unicol}, 2023-06-20.
}
\concept{Canadian university color palettes}
\keyword{datasets}
