% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/HigherOrderRiskPreferences.R
\name{compute_higher_order_risk_preferences}
\alias{compute_higher_order_risk_preferences}
\title{Computes a continuous and smooth function according to the given utility points}
\usage{
compute_higher_order_risk_preferences(
  x,
  y,
  ids = NULL,
  mode = 1,
  penalty_orders = c(4),
  ndx = 20,
  deg = 6,
  measures = c("risk-arrow-pratt", "crainich-eeckhoudt", "denuit-eeckhoudt"),
  ...,
  root_filename = NULL,
  verbose = 0
)
}
\arguments{
\item{x}{a matrix or dataframe containing the certainty equivalents (x-values of utility points) for a given participant in each use case.}

\item{y}{can be a vector or a matrix representing the corresponding utility values (y-values of utility points).}

\item{ids}{a list containing the IDs of the participants. If not given, a list with IDs from 1 to n_observations will be created.}

\item{mode}{an integer between 0, 1, 2 representing the three possible modes: multiple imputation, optimal classification or 'weak' classification. Default is optimal classification (1).}

\item{penalty_orders}{vector or constant that contains the derivates that will be smoothened. The values in this vector should not be larger than 4.}

\item{ndx}{number of intervals to partition the distance between the lowest and highest x-values of the utility points.}

\item{deg}{degree of the B-spline basis. Determines the degree of the function to be estimated. If deg = 2, the estimated utility function will consist of quadratic functions.}

\item{measures}{the utility based (intensity) measures to be computed.}

\item{...}{additional parameters for user-defined measures.}

\item{root_filename}{filename containing the location of where the output files are going to be saved.}

\item{verbose}{shows some information while the program is running.}
}
\value{
A smooth and continuous function.
}
\description{
Computes a continuous and smooth function according to the given utility points
}
\examples{
\donttest{
x <- matrix(c(24.60938,34.76074,78.75,81.86035,128.5156, 
              7.109375,80.4248,113.75,115.083,135.0781, 
              3.828125,7.211914,8.75,124.1064,131.7969, 
              1.640625,2.084961,8.75,36.94824,98.98438), nrow = 4, ncol = 5, byrow = TRUE)
y <- c(0.25, 0.375, 0.5, 0.625, 0.75)
compute_higher_order_risk_preferences(x, y, mode = 1)

# could be used with root_filename argument: 
# Linux
# outfile <- paste(dirname(getwd()), "/out", sep="")
# Win
# outfile <- paste(dirname(getwd()), "\out", sep="")
compute_higher_order_risk_preferences(x, y, mode = 2, verbose = 1)
}
}
