% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{satisfying}
\alias{satisfying}
\alias{violating}
\alias{violating.default}
\alias{lacking}
\title{Select records (not) satisfying rules}
\usage{
satisfying(x, y, include_missing = FALSE, ...)

violating(x, y, include_missing = FALSE, ...)

\method{violating}{default}(x, y, include_missing = FALSE, ...)

lacking(x, y, ...)
}
\arguments{
\item{x}{A \code{data.frame}}

\item{y}{a \code{\link{validator}} object or a \code{\link{validation}} object.}

\item{include_missing}{Toggle: also select records that have \code{NA} output for a rule?}

\item{...}{options passed to \code{\link{confront}}}
}
\value{
For \code{satisfying}, the records in \code{x} satisfying all rules or
        validation outcomes in \code{y}. For \code{violating} the records in
        \code{x} violating at least one of the rules or validation outcomes
        in \code{y}
}
\description{
Apply validation rules or validation results to a data set and select only
those that satisfy all or violate at least one rule.
}
\note{
An error is thrown if the rules or validation results in \code{y} can not be
interpreted record-by record (e.g. when one of the rules is of the form
\code{mean(foo)>0}).
}
\examples{
rules <- validator(speed >= 12, dist < 100)
satisfying(cars, rules)
violating(cars, rules)

out <- confront(cars, rules)
summary(out)
satisfying(cars, out)
violating(cars, out)

}
\concept{select-data}
