% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scramble_variables.R
\name{scramble_variables}
\alias{scramble_variables}
\title{Scrambling the content of several variables in a data frame}
\usage{
scramble_variables(data, ..., .groups = NULL, together = FALSE)
}
\arguments{
\item{data}{a data frame}

\item{...}{Columns to scramble using tidyselect semantics. Each can be:
\itemize{
\item Bare column names (e.g., \code{var1, var2})
\item A tidyselect expression (e.g., \code{starts_with("treat_")})
\item A character vector of column names (e.g., \code{c("var1", "var2")})
\item Multiple sets can be provided as separate arguments
}}

\item{.groups}{Optional grouping columns. Scrambling will be done within each group.
Supports the same tidyselect syntax as column selection. Grouping columns must not overlap with
the columns selected in \code{...}. If \code{data} is already a grouped \code{dplyr} data frame,
existing grouping is ignored unless \code{.groups} is explicitly provided.}

\item{together}{logical. If \code{TRUE}, variables are scrambled together as a unit per row.
Values across different variables are kept intact but assigned to different rows.
If \code{FALSE} (default), each variable is scrambled independently.}
}
\value{
A data frame with the specified columns scrambled. If grouping is specified, scrambling is done within each group.
}
\description{
Scramble the values of several selected variables in a data frame simultaneously.
Supports independent scrambling, joint scrambling, and within-group scrambling.
}
\examples{
df <- data.frame(
  x = 1:6,
  y = letters[1:6],
  group = c("A", "A", "A", "B", "B", "B")
)

set.seed(123)
# Example without grouping. Variables scrambled across the entire data frame.
# Using bare names
df |> scramble_variables(x, y)
# Or using character vector
df |> scramble_variables(c("x", "y"))

# Example with together = TRUE. Variables scrambled together as a unit per row.
df |> scramble_variables(c("x", "y"), together = TRUE)

# Example with grouping. Variable only scrambled within groups.
df |> scramble_variables("y", .groups = "group")

# Example combining grouping and together parameters
df |> scramble_variables(c("x", "y"), .groups = "group", together = TRUE)

# Example with tidyselect helpers
library(dplyr)
df |> scramble_variables(starts_with("x"))
df |> scramble_variables(where(is.numeric), .groups = "group")

# Example with the 'williams' dataset
data(williams)
williams |> scramble_variables(c("ecology", "age"))
williams |> scramble_variables(1:5)
williams |> scramble_variables(c("ecology", "age"), .groups = "gender")
williams |> scramble_variables(c(1, 2), .groups = 3)
williams |> scramble_variables(c("ecology", "age"), together = TRUE)
williams |> scramble_variables(c("ecology", "age"), .groups = "gender", together = TRUE)

}
\seealso{
\code{\link{scramble_values}} for scrambling a single vector, and
\code{\link{scramble_variables_rowwise}} for rowwise scrambling.
}
\keyword{scramble}
