% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine_replicates.R
\name{combine_replicates}
\alias{combine_replicates}
\title{Combine imputed replicates according to calculate totals. Combination
is done using the standard approach that makes use of the laws of total
expectation and total variance.}
\usage{
combine_replicates(
  violation,
  replicates_obs_data,
  replicates_data,
  strata_vars = NULL,
  conflict_filter = TRUE,
  forced_dis_filter = FALSE,
  edad_minors_filter = FALSE,
  include_props = FALSE,
  digits = 2
)
}
\arguments{
\item{violation}{Violation to be analyzed. Options are "homicidio", "secuestro",
"reclutamiento" and "desaparicion".}

\item{replicates_obs_data}{The data frame that results from applying \code{summary_observed}.}

\item{replicates_data}{A data frame containing replicates data.}

\item{strata_vars}{Variable with all observations (without missing values).}

\item{conflict_filter}{Filter that indicates if the data is filtered using
the "is_conflict" rule.}

\item{forced_dis_filter}{Filter that indicates if the data is filtered using the
"is_forced_dis" rule.}

\item{edad_minors_filter}{Optional filter by age (\code{edad}) < 18.}

\item{include_props}{A logical value indicating whether or not to include
the proportions from the calculations before merging with summary_observed's output.}

\item{digits}{Number of decimal places to round the results to. Default value
is 2.}
}
\value{
A data frame with 5 or more columns: name of variable(s), \code{observed}
the number of observations in each category for every variable, \code{imp_lo} the
lower bound of the 95\% confidence interval, \code{imp_hi} the upper bound of the
95\% confidence interval, and \code{imp_mean} the point estimate of the mean value.
}
\description{
Combine imputed replicates according to calculate totals. Combination
is done using the standard approach that makes use of the laws of total
expectation and total variance.
}
\examples{
\donttest{
local_dir <- system.file("extdata", "right", package = "verdata")
replicates_data <- read_replicates(local_dir, "reclutamiento", c(1, 2),
version = "v1")
replicates_obs_data <- summary_observed("reclutamiento", replicates_data,
strata_vars = "sexo", conflict_filter = FALSE, forced_dis_filter = FALSE,
edad_minors_filter = FALSE, include_props = FALSE, digits = 2)
tab_combine <- combine_replicates("reclutamiento", replicates_obs_data,
replicates_data, strata_vars = 'sexo', conflict_filter = TRUE,
forced_dis_filter = FALSE, edad_minors_filter = FALSE, include_props = FALSE,
digits = 2)
}
}
