% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/perception.R
\name{vmperception.l}
\alias{vmperception.l}
\title{Laplace-Transformed Perception Probabilities of Visual Meteor Magnitudes}
\usage{
vmperception.l(s, deriv.degree = 0L)
}
\arguments{
\item{s}{numerical; Real (non-complex) parameter for the Laplace transformation.}

\item{deriv.degree}{integer; degree of derivative of the transformation.
Currently, valid values of \code{deriv.degree} are \code{0}, \code{1} and \code{2}.}
}
\value{
returns the Laplace-transformed perception probabilities.
If \code{deriv.degree} is specified, it will return the \code{deriv.degree}-th order derivative
of these Laplace-transformed values.
}
\description{
Provides the Laplace-transformed perception probability of visual meteor magnitudes
and its first derivative.
}
\details{
The Laplace-transformed \link[=vmperception]{perception probabilities} \code{F(s)}, given as
\deqn{
F(s) = \mathcal{L} \left\{p\right\}(s)
= \int_{-0.5}^{\infty} \, f(m) \, \mathrm e^{-s \, m} \,\mathrm{d}m \,,
}
are approximately
\deqn{
    P(s) = \begin{cases}
        s^{-1} \, \exp\left(-4.11 \, s + 1.32 \, s^2 - 0.15 \, s^3\right)\ & \text{ if } s >= 0.0,\\
        \text{undefined} \  & \text{ otherwise.}
    \end{cases}
}
Here, \code{m} is the difference between the limiting magnitude and the meteor magnitude,
and \code{f(m)} denotes the perception probabilities as a function of \code{m}.
The \eqn{\mathcal{L}} recalls here the one-sided Laplace transform.

The Laplace transform is notably effective for determining the mean and variance
of observed meteor magnitudes, which are measured relative to the limiting magnitude.
This is just one example of its application.
This approach is valid only when the actual magnitude distribution adheres
to \eqn{p(m) \sim r^{-m}}, where \eqn{s = \log(r)}.
In this scenario, the mean of the observable meteor magnitudes is given by
\eqn{-\mathcal{L}'/\mathcal{L}}, and their variance is calculated as
\eqn{\mathcal{L}''/\mathcal{L} - (\mathcal{L}'/\mathcal{L})^2}.
}
\examples{
r <- 2.0
s <- log(r)
F0 <- vmperception.l(s)
F1 <- vmperception.l(s, deriv.degree=1L)
# magnitude mean
-F1/F0
F2 <- vmperception.l(s, deriv.degree=2L)
# magnitude variance
F2/F0 - (F1/F0)^2
# plot the Laplace-transformed perception probabilities
old_par <- par(mfrow = c(1,1))
plot(
    vmperception.l,
    0.2, 1.1,
    main = paste(
        'Laplace-transformed perception',
        'probability of visual meteor magnitudes'
    ),
    col = "blue",
    log = 'y',
    xlab = 's',
    ylab = 'L'
)
par(old_par)
}
\seealso{
\link{vmperception}
\link{vmgeom}
}
