% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vortexRdata_pkg_data.R
\docType{package}
\name{vortexRdata}
\alias{vortexRdata}
\alias{vortexRdata-package}
\title{vortexRdata: Example data for vortexR}
\source{
Campbell et al. (2016). Assessing the economic benefits of starling
 detection and control to Western Australia. Australasian Journal of
 Environmental Management, 23, 81-99
 \href{https://dx.doi.org/10.1080/14486563.2015.1028486}{DOI:10.1080/14486563.2015.1028486}

Pacioni, C., Williams, M., Lacy RC, Spencer, P.B.S. and Wayne, A.F. (2017)
 Predators and genetic fitness: key threatening factors for the conservation
 of bettong species. Pacific Conservation Biology.
 \href{https://doi.org/10.1071/PC17002}{DOI:10.1071/PC17002}
}
\description{
\code{vortexRdata} provides real-world example data for \code{vortexR} in both
raw (Vortex output) and binary (R objects) form.
}
\details{
\code{vortexR} uses the raw data provided here to illustrate its capability
to parse raw Vortex output files into one R object.

\code{vortexR} facilitates Post Vortex Simulation Analysis (PVSA) by offering
tools to collate multiple Vortex (v10) output files into one R object, generate
plots and conduct basic analysis (e.g. pairwise comparisons of scenarios) and
more advanced statistics such as fitting of a Generalised Linear Model (GLM)
to investigate the main and the interaction effects of the variables of
interest.

\code{vortexR} has a number of functions that are useful during the
development of a Vortex project and for its analysis after completion.

\code{vortexR} facilitates the creation of plots and
computation of basic statistics to inspect the effect of changes carried out
in the Vortex project. Once the Vortex project development is completed, the same
framework used in \code{vortexR} during the development of the project can be
refined and extended to include more advanced statistical analyses or can be
easily included in Markdown documents for the creation of reports (by
converting them into pdf) or published as web-pages.

The use of \code{vortexR} ensures reproducibility and standardises analytical
approaches in population viability analysis.
}
