% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ids_bulk_series.R
\name{ids_bulk_series}
\alias{ids_bulk_series}
\title{Retrieve Bulk Series Metadata for International Debt Statistics}
\usage{
ids_bulk_series()
}
\value{
A tibble containing the available series and their metadata:
\describe{
\item{series_id}{The unique identifier for the series (e.g.,
"BN.CAB.XOKA.CD").}
\item{series_name}{The name of the series (e.g., "Current account balance
(current US$)").}
\item{source_id}{The ID of the data source providing the indicator.}
\item{source_name}{The name or description of the source of the indicator
data.}
\item{source_note}{Additional notes or descriptions about the data source.}
\item{source_organization}{The organization responsible for the data
source.}
}
}
\description{
This function retrieves a tibble with metadata for series available via
bulk download of the World Bank International Debt Statistics (IDS).
}
\examples{
\dontshow{if (curl::has_internet() && rlang::is_installed("jsonlite")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
ids_bulk_series()
}
\dontshow{\}) # examplesIf}
}
