% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/table_mappings.R
\docType{data}
\name{items_cbs}
\alias{items_cbs}
\title{Commodity balance sheet items}
\format{
A tibble where each row corresponds to one CBS item.
It contains the following columns:
\itemize{
\item \code{item_cbs_code}: A numeric code used to refer to the CBS item.
\item \code{item_cbs_name}: A natural language name for the item.
\item \code{item_type}: An ad-hoc grouping of items. This is a work in progress
evolving depending on our needs, so for now it only has two possible
values:
\itemize{
\item \code{livestock}: The CBS item represents a live animal.
\item \code{other}: Not any of the previous groups.
}
}
}
\source{
Inspired by \href{https://www.fao.org/faostat/en/#data/FBS}{FAOSTAT data}.
}
\usage{
items_cbs
}
\description{
Defines name/code correspondences for commodity balance sheet (CBS) items.
}
\keyword{datasets}
