% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image_analysis_classification.R
\name{wbt_image_segmentation}
\alias{wbt_image_segmentation}
\title{Image segmentation}
\usage{
wbt_image_segmentation(
  inputs,
  output,
  threshold = 0.5,
  steps = 10,
  min_area = 4,
  wd = NULL,
  verbose_mode = NULL,
  compress_rasters = NULL,
  command_only = FALSE
)
}
\arguments{
\item{inputs}{Names of the input band images.}

\item{output}{Name of the output raster file.}

\item{threshold}{Distance threshold, in z-scores.}

\item{steps}{Number of steps.}

\item{min_area}{Minimum object area, in grid cells (1-8).}

\item{wd}{Changes the working directory. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_wd()} for details.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_verbose()} for details.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_compress_rasters()} for details.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool. Default: \code{FALSE}.}
}
\value{
Returns the tool text outputs.
}
\description{
Performs a region-growing based segmentation on a set of multi-spectral images.
}
\keyword{ImageProcessingToolsClassification}
