% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/WqData-class.R, R/wql-package.R
\docType{class}
\name{WqData-class}
\alias{WqData-class}
\alias{[,WqData-method}
\alias{summary,WqData-method}
\alias{plot,WqData-method}
\title{Class WqData}
\description{
A simple extension or subclass of the \code{"data.frame"} class for typical
\dQuote{discrete} water quality monitoring programs that examine phenomena
on a time scale of days or longer. It requires water quality data to be in a
specific \dQuote{long} format, although a generating function
\code{\link{wqData}} can be used for different forms of data.
}
\section{Objects from the Class}{
 Objects can be created by calls of the form
\code{new("WqData", d)}, where \code{d} is a data.frame. \code{d} should
have columns named \code{time, site, depth, variable, value} of class
\code{"DateTime", "factor", "numeric", "factor", "numeric"}, respectively.
}

\examples{

showClass("WqData")
# Construct the WqData object sfb as shown in the wqData examples.
sfb <- wqData(sfbay, c(1, 3, 4), 5:12, site.order = TRUE, type = "wide",
  time.format = "\%m/\%d/\%Y")
# Summarize the data
summary(sfb)
# Create boxplot summary of data
plot(sfb, vars = c("chl", "dox", "spm"), num.col = 2)
# Extract some of the data as a WqData object
sfb[1:10, ]  # first 10 observations
sfb[sfb$depth == 20, ]  # all observations at 20 m

}
\seealso{
\code{\link{DateTime-class}}, \code{\link{tsMake,WqData-method}},
\code{\link{wqData}}
}
\keyword{classes}
