% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/descriptives.R
\name{median_quart}
\alias{median_quart}
\title{Compute median and quartiles and put together.}
\usage{
median_quart(
  x,
  nround = NULL,
  qtype = 8,
  roundDig = 2,
  drop0 = FALSE,
  groupvar = NULL,
  range = FALSE,
  rangesep = " ",
  rangearrow = " -> ",
  prettynum = FALSE,
  .german = FALSE,
  add_n = FALSE,
  ci = FALSE,
  nrepl = 10^3,
  singleline = TRUE
)
}
\arguments{
\item{x}{Data for computation.}

\item{nround}{Number of digits for fixed round.}

\item{qtype}{Type of quantiles.}

\item{roundDig}{Number of relevant digits for roundR.}

\item{drop0}{Should trailing zeros be dropped?}

\item{groupvar}{Optional grouping variable for subgroups.}

\item{range}{Should min and max be included in output?}

\item{rangesep}{How should min/max be separated from mean+-sd?}

\item{rangearrow}{What is put between min -> max?}

\item{prettynum}{logical, apply prettyNum to results?}

\item{.german}{logical, should "." and "," be used as bigmark and decimal?}

\item{add_n}{Should n be included in output?}

\item{ci}{Should bootstrap based 95\% confidence interval be computed?}

\item{nrepl}{Number of bootstrap replications, defaults to 1000.}

\item{singleline}{Put all descriptive stats in a single element (default) or below each other. singleline = FALSE sets ci and add_n as TRUE}
}
\value{
Either character vector with median \code{[1stQuartile/3rdQuartile]} and additional results (singleline), or matrix with rows for n, median with CI, and quartiles, and optionally range.
}
\description{
Compute median and quartiles and put together.
}
\examples{
# basic usage of median_quart
median_quart(x = mtcars$wt)
# with additional options
median_quart(x = mtcars$wt, groupvar = mtcars$am, add_n = TRUE)
data(faketrial)
median_quart(x = faketrial$`Biomarker 1 [units]`, groupvar = faketrial$Treatment)
}
