% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaDfScaleFactor.R
\name{xegaDfScaleFactorFactory}
\alias{xegaDfScaleFactorFactory}
\title{Configure the scale factor function for differential mutation.}
\usage{
xegaDfScaleFactorFactory(method = "Const")
}
\arguments{
\item{method}{A string specifying the scale factor function.}
}
\value{
A scale factor function for genes.
}
\description{
\code{xegaDfScaleFactorFactory()} implements the selection
             of one of the scale factor functions in this
             package by specifying a text string.
             The selection fails ungracefully (produces
             a runtime error) if the label does not match.
             The functions are specified locally.

             Current support:

             \enumerate{
             \item "Const" returns \code{ConstScaleFactor()}.
             \item "Uniform" returns \code{UniformRandomScaleFactor()}.
             }
}
\details{
In the literature, several approaches have been suggested.
         For a review see Sharma et al. (2019).
}
\examples{
f<-xegaDfScaleFactorFactory("Const")
f(lFxegaDfGene)
f<-xegaDfScaleFactorFactory("Uniform")
f(lFxegaDfGene)
f(lFxegaDfGene)
}
\references{
Sharma, Prashant; Sharma, Harish; Kumar, Sandeep; Bansal, Jagdish Chand
(2019):
A Review on Scale Factor Strategies in Differential Evolution Algorithm.
pp. 925-934. In:
Bansal, Jagdish Chand et al. (2019)
Soft Computing for Problem Solving.
Advances in Intelligent Systems and Computing, Vol. 817.
Springer, Singapore, 2019. (ISBN:978-981-13-1594-7)
}
\seealso{
Other Configuration: 
\code{\link{lFxegaDfGene}},
\code{\link{xegaDfCrossoverFactory}()},
\code{\link{xegaDfGeneMapFactory}()},
\code{\link{xegaDfMutationFactory}()},
\code{\link{xegaDfReplicationFactory}()}
}
\concept{Configuration}
