% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/newXOR.R
\name{newEnvXOR}
\alias{newEnvXOR}
\title{Generates a problem environment for the XOR problem.}
\usage{
newEnvXOR()
}
\value{
The problem environment for the XOR problem with 
        \itemize{
\item \code{$name}: 
        \code{"envXOR"}, the name of the problem environment.
\item \code{$buildtest(expr)}: 
                              The function which builds the environment 
                              for evaluating the expression 
                              by binding the variables to the parameters.
\item \code{$TestCases}: The truthtable of the XOR function.
\item \code{$f(expr, gene=NULL, lF=NULL)}: The fitness function.
                             \code{expr} is the string with the 
                             logical expression to be evaluated. 
        }

The problem environment.
}
\description{
Generates a problem environment for the XOR problem.
}
\examples{
envXOR<-newEnvXOR()
envXOR$name()
a2<-"OR(OR(D1, D2), (AND(NOT(D1), NOT(D2))))"
a3<-"OR(OR(D1, D2), AND(D1, D2))"
a4<-"AND(OR(D1,D2),NOT(AND(D1,D2)))"
gp4<-"(AND(AND(OR(D2,D1),NOT(AND(D1,D2))),(OR(D2,D1))))"
envXOR$f(a2)
envXOR$f(a3)
envXOR$f(a4)
envXOR$f(gp4)

}
\seealso{
Other Problem Environments: 
\code{\link{DeJongF4Factory}()},
\code{\link{DelayedPFactory}()},
\code{\link{Parabola2DEarlyFactory}()},
\code{\link{Parabola2DErrFactory}()},
\code{\link{Parabola2DFactory}()},
\code{\link{envXOR}},
\code{\link{lau15}},
\code{\link{newTSP}()}
}
\concept{Problem Environments}
