% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{desc_from_comments}
\alias{desc_from_comments}
\title{Backfill utility for descriptions}
\usage{
desc_from_comments(
  xpdb,
  start_check = ".*description",
  maxlines = 5,
  remove = paste0(start_check, ":\\\\s*"),
  extra_proc = c,
  collapse = " "
)
}
\arguments{
\item{xpdb}{<\code{xpose_data}> or <\code{xp_xtras}> object}

\item{start_check}{Regular expression used to mark start of description.
This is tested case-insensitively.}

\item{maxlines}{If the number of lines after description to the first
code block is more than 1, this allows a limit.}

\item{remove}{By default, the start check and a colon, with optional whitespace.
A regex.}

\item{extra_proc}{Any extra processing that might be desired prior to
collapsing the description lines. This should be a vectorized function.}

\item{collapse}{Character to use when collapsing multiple lines.}
}
\value{
The description-updated <\code{xpose_data}) object
}
\description{
A slightly more generic approach to getting model
descriptions.
}
\examples{

# This has a description, but it's not visible by default
pheno_base

# It can be added with the following
pheno_base \%>\%
  desc_from_comments()

# Extra processing for preference can also implemented
pheno_base \%>\%
  desc_from_comments(extra_proc = tolower)

# If a run label ($PROB) would make a good description, use the
# following instead:
pkpd_m3 \%>\%
  set_prop(descr=get_prop(pkpd_m3,"label"))


}
\seealso{
\code{\link[=set_prop]{set_prop()}}
}
