% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basic.gof.R
\name{basic.gof}
\alias{basic.gof}
\title{Basic goodness-of-fit plots, for Xpose 4}
\usage{
basic.gof(object, force.wres = FALSE, main = "Default", use.log = FALSE, ...)
}
\arguments{
\item{object}{An xpose.data object.}

\item{force.wres}{Should the plots use WRES?  Values can be
\code{TRUE/FALSE}.  Otherwise the CWRES are used if present.}

\item{main}{The title of the plot.  If \code{"Default"} then a default title
is plotted. Otherwise the value should be a string like \code{"my title"} or
\code{NULL} for no plot title.}

\item{use.log}{Should we use log transformations in the plots?}

\item{\dots}{Other arguments passed to \code{\link{xpose.plot.default}}.}
}
\value{
Returns a compound plot comprising plots of observations (DV) vs
population predictions (PRED), DV vs individual predictions (IPRED),
absolute individual weighted residuals (|IWRES|) vs IPRED, and weighted
populations residuals (WRES) vs the independent variable (IDV).
}
\description{
This is a compound plot consisting of plots of observations (DV) vs
population predictions (PRED), observations (DV) vs individual predictions
(IPRED), absolute individual weighted residuals (|IWRES|) vs IPRED, and
weighted population residuals (CWRES) vs independent variable (IDV), a
specific function in Xpose 4. WRES are also supported. It is a wrapper
encapsulating arguments to the \code{dv.vs.pred}, \code{dv.vs.ipred},
\code{absval.iwres.vs.ipred} and \code{wres.vs.idv} functions.
}
\details{
Four basic goodness-of-fit plots are presented side by side for comparison.

Conditional weighted residuals (CWRES) require some extra steps to
calculate. See \code{\link{compute.cwres}} for details.

A wide array of extra options controlling xyplots are available. See
\code{\link{xpose.plot.default}} for details.

\code{basic.gof.cwres} is just a wrapper for \code{basic.gof} with
\code{use.cwres=TRUE}.
}
\examples{

basic.gof(simpraz.xpdb)

}
\seealso{
\code{\link{dv.vs.pred}}, \code{\link{dv.vs.ipred}},
\code{\link{absval.iwres.vs.ipred}}, \code{\link{wres.vs.idv}},
\code{\link{cwres.vs.idv}}, \code{\link{xpose.plot.default}},
\code{\link{xpose.panel.default}}, \code{\link[lattice]{xyplot}},
\code{\link{compute.cwres}}, \code{\link{xpose.prefs-class}},
\code{\link{xpose.data-class}}

Other specific functions: 
\code{\link{absval.cwres.vs.cov.bw}()},
\code{\link{absval.cwres.vs.pred}()},
\code{\link{absval.cwres.vs.pred.by.cov}()},
\code{\link{absval.iwres.cwres.vs.ipred.pred}()},
\code{\link{absval.iwres.vs.cov.bw}()},
\code{\link{absval.iwres.vs.idv}()},
\code{\link{absval.iwres.vs.ipred}()},
\code{\link{absval.iwres.vs.ipred.by.cov}()},
\code{\link{absval.iwres.vs.pred}()},
\code{\link{absval.wres.vs.cov.bw}()},
\code{\link{absval.wres.vs.idv}()},
\code{\link{absval.wres.vs.pred}()},
\code{\link{absval.wres.vs.pred.by.cov}()},
\code{\link{absval_delta_vs_cov_model_comp}},
\code{\link{addit.gof}()},
\code{\link{autocorr.cwres}()},
\code{\link{autocorr.iwres}()},
\code{\link{autocorr.wres}()},
\code{\link{basic.model.comp}()},
\code{\link{cat.dv.vs.idv.sb}()},
\code{\link{cat.pc}()},
\code{\link{cov.splom}()},
\code{\link{cwres.dist.hist}()},
\code{\link{cwres.dist.qq}()},
\code{\link{cwres.vs.cov}()},
\code{\link{cwres.vs.idv}()},
\code{\link{cwres.vs.idv.bw}()},
\code{\link{cwres.vs.pred}()},
\code{\link{cwres.vs.pred.bw}()},
\code{\link{cwres.wres.vs.idv}()},
\code{\link{cwres.wres.vs.pred}()},
\code{\link{dOFV.vs.cov}()},
\code{\link{dOFV.vs.id}()},
\code{\link{dOFV1.vs.dOFV2}()},
\code{\link{data.checkout}()},
\code{\link{dv.preds.vs.idv}()},
\code{\link{dv.vs.idv}()},
\code{\link{dv.vs.ipred}()},
\code{\link{dv.vs.ipred.by.cov}()},
\code{\link{dv.vs.ipred.by.idv}()},
\code{\link{dv.vs.pred}()},
\code{\link{dv.vs.pred.by.cov}()},
\code{\link{dv.vs.pred.by.idv}()},
\code{\link{dv.vs.pred.ipred}()},
\code{\link{gof}()},
\code{\link{ind.plots}()},
\code{\link{ind.plots.cwres.hist}()},
\code{\link{ind.plots.cwres.qq}()},
\code{\link{ipred.vs.idv}()},
\code{\link{iwres.dist.hist}()},
\code{\link{iwres.dist.qq}()},
\code{\link{iwres.vs.idv}()},
\code{\link{kaplan.plot}()},
\code{\link{par_cov_hist}},
\code{\link{par_cov_qq}},
\code{\link{parm.vs.cov}()},
\code{\link{parm.vs.parm}()},
\code{\link{pred.vs.idv}()},
\code{\link{ranpar.vs.cov}()},
\code{\link{runsum}()},
\code{\link{wres.dist.hist}()},
\code{\link{wres.dist.qq}()},
\code{\link{wres.vs.idv}()},
\code{\link{wres.vs.idv.bw}()},
\code{\link{wres.vs.pred}()},
\code{\link{wres.vs.pred.bw}()},
\code{\link{xpose.VPC}()},
\code{\link{xpose.VPC.both}()},
\code{\link{xpose.VPC.categorical}()},
\code{\link{xpose4-package}}
}
\author{
E. Niclas Jonsson, Mats Karlsson, Andrew Hooker & Justin Wilkins
}
\concept{specific functions}
