% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/groups.R
\name{decorate_groups.data.frame}
\alias{decorate_groups.data.frame}
\title{Capture Groups as Decorations for Data Frame}
\usage{
\method{decorate_groups}{data.frame}(x, ...)
}
\arguments{
\item{x}{data.frame}

\item{...}{unquoted names of columns to assign as groups; defaults to \code{groups(x)}}
}
\value{
same class as x
}
\description{
Captures groups as decorations for class 'data.frame'.
Creates a sequentially-valued integer attribute 
with name 'groups' for each corresponding column
(after clearing all such existing designations).
It is an error if not all such columns are present.
Defaults to \code{groups(x)}. If no columns are 
specified and x has no groups, x is returned
with any existing column-level 'groups' attributes
removed.
}
\examples{
library(magrittr)
library(dplyr)
Theoph \%>\% decorate_groups(Subject, Time) \%>\% groups # nothing!
Theoph \%>\% decorate_groups(Subject, Time) \%>\% decorations # note well
Theoph \%>\% group_by(Subject, Time) \%>\% decorate_groups \%>\% decorations # same

}
\seealso{
Other decorate: 
\code{\link{as_decorated}()},
\code{\link{as_decorated.default}()},
\code{\link{decorate}()},
\code{\link{decorate.character}()},
\code{\link{decorate.data.frame}()},
\code{\link{decorate.list}()},
\code{\link{decorate_groups}()},
\code{\link{decorations}()},
\code{\link{decorations.data.frame}()},
\code{\link{decorations_groups}()},
\code{\link{decorations_groups.data.frame}()},
\code{\link{group_by_decorations}()},
\code{\link{group_by_decorations.data.frame}()},
\code{\link{redecorate}()}
}
\concept{decorate}
