% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\name{z22_data}
\alias{z22_data}
\title{Get Census 2022 grid dataset}
\usage{
z22_data(
  feature,
  categories = NULL,
  year = 2022,
  res = "1km",
  all_cells = FALSE,
  normalize = FALSE,
  rasterize = FALSE,
  as_sf = FALSE,
  update_cache = FALSE
)
}
\arguments{
\item{feature}{A grid feature. See \code{\link{z22_features}} for a list
of available features. You can pass both English names and legacy names
(i.e., variable names from the 2011 census).}

\item{categories}{One or multiple feature categories. See
\code{\link{z22_categories}} for a list of available categories. If
\code{NULL}, retrieves all categories for a given feature. Generally,
the more categories are selected, the longer the download.}

\item{year}{Census year. Currently, only 2011 and 2022 are available.
Defaults to 2022.}

\item{res}{Resolution of the grid dataset. Can be \code{"100m"},
\code{"1km"}, or \code{"10km"}. If \code{year} is 2011, \code{"10km"} is
not available and some features are only available at certain resolutions.}

\item{all_cells}{If \code{TRUE}, joins the retrieved attribute with the
complete grid from \code{\link{z22_grid}}. Otherwise, the attribute grid
will contain only those grid cells with one or more recorded units. Defaults
to \code{FALSE}, because loading the grid and joining with it is
computationally expensive.}

\item{normalize}{If \code{TRUE} and \code{feature} is a counted feature,
computes shares by dividing the counts by the total number of units in the
grid cell. The type of unit depends on the theme of the feature, e.g., if
the feature is in theme "Buildings", the feature counts are divided by the
total number of buildings. Note that this operation requires an additional
download (the total number of units). Also note that sometimes (possibly due
to the key-cell method), shares of over 1 are computed. Defaults to
\code{FALSE}.}

\item{rasterize}{If \code{TRUE} and the \code{terra} package is installed,
converts the attribute coordinates to a \code{\link[terra:rast]{SpatRaster}}.}

\item{as_sf}{If \code{TRUE} and the \code{sf} package is installed,
converts the attribute coordinates to an \code{sf} tibble.}

\item{update_cache}{By default, both functions cache attribute files for
the remainder of the R session. They are downloaded to a temporary directory
and - if the file to download already exists - are recovered from the cache.
In other words, when rerunning the same request multiple times, the
subsequent calls should be much faster. If \code{TRUE}, disables caching
for this call and overwrites the currently cached attribute file (if any)
with a fresh one. Defaults to \code{FALSE}, i.e. always cache.}
}
\value{
A tibble, \code{\link[terra:sds]{SpatRasterDataset}} or
\code{\link[sf:st_as_sf]{sf}} tibble depending on the \code{rasterize}
and \code{as_sf} arguments.

If a tibble is returned each category in \code{categories} is stored in
a column. If a \code{SpatRasterDataset} is returned, each category is a
named layer.
}
\description{
Retrieve the values and coordinates of gridded features from the censuses
2011 and 2022.

When we are talking about a

\itemize{
 \item{\strong{feature}, we talk about an indicator aggregated to grid cells,
 e.g., age or the number of dwellings.}
 \item{\strong{category}, we talk about the discrete classifications of
 features, e.g., ages 10 to 19, 20 to 20, 30 to 39, etc.}
 \item{Both feature and category have to be provided to uniquely identify
 a \strong{dataset}.}
}
}
\details{
Half of the grids cell width is added to each coordinate in the
dataset internally. According to the INSPIRE guidelines, coordinates
always represent the South-west of the grid cells. Centroids represent
the geographic location of grid cells better which is why they are used.

By default, data are downloaded from the
\href{https://github.com/jslth/z22data}{z22data} data repository which
stores all pre-processed data. You can download this repository and use
it offline or use an entirely different repository by setting
\code{options(z22.data_repo = "path/to/z22data")}.
}
\examples{
\dontshow{if (arrow::codec_is_available("zstd")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{# Get gridded population
pop <- z22_data("population", res = "10km", rasterize = TRUE)
terra::plot(pop$cat_0)

# Get data about the number of people born in a EU27 country
z22_data("birth_country", categories = 21, res = "1km")}
\dontshow{\}) # examplesIf}
}
