% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handle-weight-files.R
\name{parse.pgs.input.header}
\alias{parse.pgs.input.header}
\title{Parse PGS input file header}
\usage{
parse.pgs.input.header(pgs.weight.path)
}
\arguments{
\item{pgs.weight.path}{A character string indicating the path to the pgs weight file.}
}
\value{
A data frame containing the metadata from the file header.
}
\description{
Parse metadata from a PGS input file header.
}
\examples{
# Example pgs weight file
pgs.weight.path <- system.file(
    'extdata',
    'PGS000662_hmPOS_GRCh38.txt.gz',
    package = 'ApplyPolygenicScore',
    mustWork = TRUE
    );
parse.pgs.input.header(pgs.weight.path);
}
