% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/MakeSigMatrix.R
\name{shrinkSigMatrix}
\alias{shrinkSigMatrix}
\title{Shrink a signature matrix}
\usage{
shrinkSigMatrix(
  sigMatrix,
  numChunks = 100,
  verbose = FALSE,
  plotIt = FALSE,
  aggressiveMin = TRUE,
  sigGenesList = NULL,
  singleCore = FALSE,
  fastStop = TRUE
)
}
\arguments{
\item{sigMatrix}{The original signature matrix}

\item{numChunks}{The number of groups of genes to remove. NULL is all genes (DEFAULT: 100)}

\item{verbose}{Print out the current chunk as is it's being calculated (DEFAULT: NULL)}

\item{plotIt}{Set to TRUE to plot (DEFAULT: FALSE)}

\item{aggressiveMin}{Set to TRUE to aggresively seek the smallest number of genes (DEFAULT: TRUE)}

\item{sigGenesList}{Set to use precomputed results from shrinkByKappa (DEFAULT: NULL)}

\item{singleCore}{Set to FALSE to use multiple cores to calculate condition numbers (DEFAULT: FALSE)}

\item{fastStop}{Halt early when the condition number changes by less than 1 for 3 iterations (DEFAULT: TRUE)}
}
\value{
A list with condition numbers and gene lists
}
\description{
Use shrinkByKappa and automatic minima detection to reduce a signature matrix.
Select the new signature matrix with the minima and the maximum number of genes.  There is an
inherent difficult in that the condition number will tend to have a second peak at a relatively
small number of genes, and then crash so that smallest condition number has more or less one gene.

By default, the algorithm will tend to pick the detected minima with the largest nubmer of genes.
aggressiveMin=TRUE will try to find the minimum number of genes that has more genes than the 
maxima at the smallest number of genes
}
\examples{
library(ADAPTS)
LM22 <- ADAPTS::LM22
newSigMat <- shrinkSigMatrix(sigMatrix=LM22[1:100,1:5], numChunks=4, verbose=FALSE, 
plotIt=FALSE, aggressiveMin=TRUE, sigGenesList=NULL, singleCore=TRUE, fastStop=FALSE)

}
